/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.collections.bitmap;

import java.nio.IntBuffer;
import org.apache.druid.collections.bitmap.ConcisePeekableIteratorAdapter;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.extendedset.intset.ImmutableConciseSet;
import org.roaringbitmap.IntIterator;
import org.roaringbitmap.PeekableIntIterator;

public class WrappedImmutableConciseBitmap
implements ImmutableBitmap {
    private final ImmutableConciseSet bitmap;

    public WrappedImmutableConciseBitmap(IntBuffer buffer) {
        this.bitmap = new ImmutableConciseSet(buffer);
    }

    public WrappedImmutableConciseBitmap(ImmutableConciseSet immutableConciseSet) {
        this.bitmap = immutableConciseSet;
    }

    public ImmutableConciseSet getBitmap() {
        return this.bitmap;
    }

    @Override
    public boolean get(int value) {
        return this.bitmap.contains(value);
    }

    @Override
    public byte[] toBytes() {
        return this.bitmap.toBytes();
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.bitmap;
    }

    @Override
    public IntIterator iterator() {
        return this.bitmap.iterator();
    }

    @Override
    public PeekableIntIterator peekableIterator() {
        return new ConcisePeekableIteratorAdapter(this.bitmap.iterator());
    }

    @Override
    public int size() {
        return this.bitmap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.bitmap.size() == 0;
    }

    @Override
    public ImmutableBitmap intersection(ImmutableBitmap otherBitmap) {
        WrappedImmutableConciseBitmap other = (WrappedImmutableConciseBitmap)otherBitmap;
        ImmutableConciseSet unwrappedOtherBitmap = other.bitmap;
        return new WrappedImmutableConciseBitmap(ImmutableConciseSet.intersection((ImmutableConciseSet[])new ImmutableConciseSet[]{this.bitmap, unwrappedOtherBitmap}));
    }
}

