/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import java.io.Closeable;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerFactory;
import org.apache.druid.query.ReportTimelineMissingSegmentQueryRunner;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.segment.ReferenceCountingSegment;

public class ReferenceCountingSegmentQueryRunner<T>
implements QueryRunner<T> {
    private final QueryRunnerFactory<T, Query<T>> factory;
    private final ReferenceCountingSegment adapter;
    private final SegmentDescriptor descriptor;

    public ReferenceCountingSegmentQueryRunner(QueryRunnerFactory<T, Query<T>> factory, ReferenceCountingSegment adapter, SegmentDescriptor descriptor) {
        this.factory = factory;
        this.adapter = adapter;
        this.descriptor = descriptor;
    }

    @Override
    public Sequence<T> run(QueryPlus<T> queryPlus, ResponseContext responseContext) {
        if (this.adapter.increment()) {
            try {
                Sequence<T> baseSequence = this.factory.createRunner(this.adapter).run(queryPlus, responseContext);
                return Sequences.withBaggage(baseSequence, (Closeable)this.adapter.decrementOnceCloseable());
            }
            catch (Throwable t) {
                try {
                    this.adapter.decrement();
                }
                catch (Exception e) {
                    t.addSuppressed(e);
                }
                throw t;
            }
        }
        return new ReportTimelineMissingSegmentQueryRunner<T>(this.descriptor).run(queryPlus, responseContext);
    }
}

