/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import java.util.List;
import java.util.function.Function;
import org.apache.druid.java.util.common.Numbers;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.DelegatingAggregator;
import org.apache.druid.segment.BaseDoubleColumnValueSelector;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.selector.settable.SettableValueDoubleColumnValueSelector;

public class StringColumnDoubleAggregatorWrapper
extends DelegatingAggregator {
    private final BaseObjectColumnValueSelector selector;
    private final double nullValue;
    private final SettableValueDoubleColumnValueSelector doubleSelector = new SettableValueDoubleColumnValueSelector();

    public StringColumnDoubleAggregatorWrapper(BaseObjectColumnValueSelector selector, Function<BaseDoubleColumnValueSelector, Aggregator> delegateBuilder, double nullValue) {
        this.selector = selector;
        this.nullValue = nullValue;
        this.delegate = delegateBuilder.apply(this.doubleSelector);
    }

    @Override
    public void aggregate() {
        Object update = this.selector.getObject();
        if (update == null) {
            this.doubleSelector.setValue(this.nullValue);
            this.delegate.aggregate();
        } else if (update instanceof List) {
            for (Object o : (List)update) {
                this.doubleSelector.setValue(Numbers.tryParseDouble(o, (double)this.nullValue));
                this.delegate.aggregate();
            }
        } else {
            this.doubleSelector.setValue(Numbers.tryParseDouble(update, (double)this.nullValue));
            this.delegate.aggregate();
        }
    }
}

