/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.hyperloglog;

import java.nio.ByteBuffer;
import org.apache.druid.hll.HyperLogLogCollector;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.BaseObjectColumnValueSelector;

public class HyperUniquesBufferAggregator
implements BufferAggregator {
    private static final byte[] EMPTY_BYTES = HyperLogLogCollector.makeEmptyVersionedByteArray();
    private final BaseObjectColumnValueSelector selector;

    public HyperUniquesBufferAggregator(BaseObjectColumnValueSelector selector) {
        this.selector = selector;
    }

    public static void doInit(ByteBuffer buf, int position) {
        ByteBuffer mutationBuffer = buf.duplicate();
        mutationBuffer.position(position);
        mutationBuffer.put(EMPTY_BYTES);
    }

    public static HyperLogLogCollector doGet(ByteBuffer buf, int position) {
        int size = HyperLogLogCollector.getLatestNumBytesForDenseStorage();
        ByteBuffer dataCopyBuffer = ByteBuffer.allocate(size);
        ByteBuffer mutationBuffer = buf.duplicate();
        mutationBuffer.position(position);
        mutationBuffer.limit(position + size);
        dataCopyBuffer.put(mutationBuffer);
        dataCopyBuffer.rewind();
        return HyperLogLogCollector.makeCollector((ByteBuffer)dataCopyBuffer);
    }

    @Override
    public void init(ByteBuffer buf, int position) {
        HyperUniquesBufferAggregator.doInit(buf, position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void aggregate(ByteBuffer buf, int position) {
        HyperLogLogCollector collector = (HyperLogLogCollector)this.selector.getObject();
        if (collector == null) {
            return;
        }
        int oldPosition = buf.position();
        int oldLimit = buf.limit();
        buf.limit(position + HyperLogLogCollector.getLatestNumBytesForDenseStorage());
        buf.position(position);
        try {
            HyperLogLogCollector.makeCollector((ByteBuffer)buf).fold(collector);
        }
        finally {
            buf.limit(oldLimit);
            buf.position(oldPosition);
        }
    }

    @Override
    public Object get(ByteBuffer buf, int position) {
        return HyperUniquesBufferAggregator.doGet(buf, position);
    }

    @Override
    public float getFloat(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("HyperUniquesBufferAggregator does not support getFloat()");
    }

    @Override
    public long getLong(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("HyperUniquesBufferAggregator does not support getLong()");
    }

    @Override
    public double getDouble(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("HyperUniquesBufferAggregator does not support getDouble()");
    }

    @Override
    public void close() {
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("selector", this.selector);
    }
}

