/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.hyperloglog;

import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.List;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.hll.HyperLogLogCollector;
import org.apache.druid.hll.HyperLogLogHash;
import org.apache.druid.segment.GenericColumnSerializer;
import org.apache.druid.segment.column.ColumnBuilder;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.data.ObjectStrategy;
import org.apache.druid.segment.serde.ComplexColumnPartSupplier;
import org.apache.druid.segment.serde.ComplexMetricExtractor;
import org.apache.druid.segment.serde.ComplexMetricSerde;
import org.apache.druid.segment.serde.LargeColumnSupportedComplexColumnSerializer;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public class HyperUniquesSerde
extends ComplexMetricSerde {
    private static Comparator<HyperLogLogCollector> comparator = Comparator.nullsFirst(Comparator.comparing(HyperLogLogCollector::toByteBuffer));
    private final HyperLogLogHash hyperLogLogHash;

    public HyperUniquesSerde() {
        this(HyperLogLogHash.getDefault());
    }

    public HyperUniquesSerde(HyperLogLogHash hyperLogLogHash) {
        this.hyperLogLogHash = hyperLogLogHash;
    }

    @Override
    public String getTypeName() {
        return "hyperUnique";
    }

    @Override
    public ComplexMetricExtractor<HyperLogLogCollector> getExtractor() {
        return new ComplexMetricExtractor<HyperLogLogCollector>(){

            @Override
            public Class<HyperLogLogCollector> extractedClass() {
                return HyperLogLogCollector.class;
            }

            @Override
            public HyperLogLogCollector extractValue(InputRow inputRow, String metricName) {
                Object rawValue = inputRow.getRaw(metricName);
                if (rawValue instanceof HyperLogLogCollector) {
                    return (HyperLogLogCollector)rawValue;
                }
                HyperLogLogCollector collector = HyperLogLogCollector.makeLatestCollector();
                List dimValues = inputRow.getDimension(metricName);
                if (dimValues == null) {
                    return collector;
                }
                for (String dimensionValue : dimValues) {
                    collector.add(HyperUniquesSerde.this.hyperLogLogHash.hash(dimensionValue));
                }
                return collector;
            }
        };
    }

    @Override
    public void deserializeColumn(ByteBuffer byteBuffer, ColumnBuilder columnBuilder) {
        GenericIndexed column = GenericIndexed.read(byteBuffer, this.getObjectStrategy(), columnBuilder.getFileMapper());
        columnBuilder.setComplexColumnSupplier(new ComplexColumnPartSupplier(this.getTypeName(), column));
    }

    @Override
    public ObjectStrategy getObjectStrategy() {
        return new ObjectStrategy<HyperLogLogCollector>(){

            @Override
            public Class<HyperLogLogCollector> getClazz() {
                return HyperLogLogCollector.class;
            }

            @Override
            public HyperLogLogCollector fromByteBuffer(ByteBuffer buffer, int numBytes) {
                ByteBuffer readOnlyBuffer = buffer.asReadOnlyBuffer();
                readOnlyBuffer.limit(readOnlyBuffer.position() + numBytes);
                return HyperLogLogCollector.makeCollector((ByteBuffer)readOnlyBuffer);
            }

            @Override
            public byte[] toBytes(HyperLogLogCollector collector) {
                if (collector == null) {
                    return new byte[0];
                }
                ByteBuffer val = collector.toByteBuffer();
                byte[] retVal = new byte[val.remaining()];
                val.asReadOnlyBuffer().get(retVal);
                return retVal;
            }

            @Override
            public int compare(HyperLogLogCollector o1, HyperLogLogCollector o2) {
                return comparator.compare(o1, o2);
            }
        };
    }

    @Override
    public GenericColumnSerializer getSerializer(SegmentWriteOutMedium segmentWriteOutMedium, String column) {
        return LargeColumnSupportedComplexColumnSerializer.create(segmentWriteOutMedium, column, this.getObjectStrategy());
    }
}

