/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import java.net.Inet4Address;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.expression.ExprUtils;
import org.apache.druid.query.expression.IPv4AddressExprUtils;

public class IPv4AddressStringifyExprMacro
implements ExprMacroTable.ExprMacro {
    public static final String NAME = "ipv4_stringify";

    public String name() {
        return NAME;
    }

    public Expr apply(List<Expr> args) {
        if (args.size() != 1) {
            throw new IAE(ExprUtils.createErrMsg(this.name(), "must have 1 argument"), new Object[0]);
        }
        Expr arg = args.get(0);
        class IPv4AddressStringifyExpr
        extends ExprMacroTable.BaseScalarUnivariateMacroFunctionExpr {
            IPv4AddressStringifyExpr(Expr arg) {
                super(arg);
            }

            @Nonnull
            public ExprEval eval(Expr.ObjectBinding bindings) {
                ExprEval eval = this.arg.eval(bindings);
                switch (eval.type()) {
                    case STRING: {
                        return IPv4AddressStringifyExprMacro.evalAsString(eval);
                    }
                    case LONG: {
                        return IPv4AddressStringifyExprMacro.evalAsLong(eval);
                    }
                }
                return ExprEval.of(null);
            }

            public Expr visit(Expr.Shuttle shuttle) {
                Expr newArg = this.arg.visit(shuttle);
                return shuttle.visit((Expr)new IPv4AddressStringifyExpr(newArg));
            }
        }
        return new IPv4AddressStringifyExpr(arg);
    }

    private static ExprEval evalAsString(ExprEval eval) {
        if (IPv4AddressExprUtils.isValidAddress(eval.asString())) {
            return eval;
        }
        return ExprEval.of(null);
    }

    private static ExprEval evalAsLong(ExprEval eval) {
        if (eval.isNumericNull()) {
            return ExprEval.of(null);
        }
        long longValue = eval.asLong();
        if (IPv4AddressExprUtils.overflowsUnsignedInt(longValue)) {
            return ExprEval.of(null);
        }
        Inet4Address address = IPv4AddressExprUtils.parse((int)longValue);
        return ExprEval.of((String)IPv4AddressExprUtils.toString(address));
    }
}

