/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter;

import org.apache.druid.query.filter.DruidLongPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.ValueGetter;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.filter.ValueMatcherColumnSelectorStrategy;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.DimensionHandlerUtils;

public class LongValueMatcherColumnSelectorStrategy
implements ValueMatcherColumnSelectorStrategy<BaseLongColumnValueSelector> {
    @Override
    public ValueMatcher makeValueMatcher(final BaseLongColumnValueSelector selector, String value) {
        Long matchVal = DimensionHandlerUtils.convertObjectToLong(value);
        if (matchVal == null) {
            return ValueMatcher.primitiveNullValueMatcher(selector);
        }
        final long matchValLong = matchVal;
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                if (selector.isNull()) {
                    return false;
                }
                return selector.getLong() == matchValLong;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", selector);
            }
        };
    }

    @Override
    public ValueMatcher makeValueMatcher(final BaseLongColumnValueSelector selector, DruidPredicateFactory predicateFactory) {
        final DruidLongPredicate predicate = predicateFactory.makeLongPredicate();
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                if (selector.isNull()) {
                    return predicate.applyNull();
                }
                return predicate.applyLong(selector.getLong());
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", selector);
                inspector.visit("predicate", predicate);
            }
        };
    }

    @Override
    public ValueGetter makeValueGetter(BaseLongColumnValueSelector selector) {
        return () -> {
            if (selector.isNull()) {
                return null;
            }
            return new String[]{Long.toString(selector.getLong())};
        };
    }
}

