/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter.vector;

import javax.annotation.Nullable;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.vector.BaseVectorValueMatcher;
import org.apache.druid.query.filter.vector.ReadableVectorMatch;
import org.apache.druid.query.filter.vector.VectorMatch;
import org.apache.druid.query.filter.vector.VectorValueMatcher;
import org.apache.druid.segment.vector.VectorValueSelector;

public interface VectorValueMatcherFactory {
    public VectorValueMatcher makeMatcher(@Nullable String var1);

    public VectorValueMatcher makeMatcher(DruidPredicateFactory var1);

    default public VectorValueMatcher makeNullValueMatcher(final VectorValueSelector selector) {
        return new BaseVectorValueMatcher(selector){
            final VectorMatch match;
            {
                super(selector2);
                this.match = VectorMatch.wrap(new int[selector.getMaxVectorSize()]);
            }

            @Override
            public ReadableVectorMatch match(ReadableVectorMatch mask) {
                boolean[] nullVector = selector.getNullVector();
                if (nullVector == null) {
                    return VectorMatch.allFalse();
                }
                int[] selection = this.match.getSelection();
                int numRows = 0;
                for (int i = 0; i < mask.getSelectionSize(); ++i) {
                    int rowNum = mask.getSelection()[i];
                    if (!nullVector[rowNum]) continue;
                    selection[numRows++] = rowNum;
                }
                this.match.setSelectionSize(numRows);
                assert (this.match.isValid(mask));
                return this.match;
            }
        };
    }
}

