/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.druid.collections.NonBlockingPool;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.guava.BaseSequence;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.ColumnSelectorPlus;
import org.apache.druid.query.QueryConfig;
import org.apache.druid.query.aggregation.AggregatorAdapters;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.dimension.ColumnSelectorStrategyFactory;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.epinephelinae.AbstractBufferHashGrouper;
import org.apache.druid.query.groupby.epinephelinae.BufferArrayGrouper;
import org.apache.druid.query.groupby.epinephelinae.BufferHashGrouper;
import org.apache.druid.query.groupby.epinephelinae.CloseableGrouperIterator;
import org.apache.druid.query.groupby.epinephelinae.Grouper;
import org.apache.druid.query.groupby.epinephelinae.GrouperBufferComparatorUtils;
import org.apache.druid.query.groupby.epinephelinae.IntGrouper;
import org.apache.druid.query.groupby.epinephelinae.LimitedBufferHashGrouper;
import org.apache.druid.query.groupby.epinephelinae.column.DictionaryBuildingStringGroupByColumnSelectorStrategy;
import org.apache.druid.query.groupby.epinephelinae.column.DoubleGroupByColumnSelectorStrategy;
import org.apache.druid.query.groupby.epinephelinae.column.FloatGroupByColumnSelectorStrategy;
import org.apache.druid.query.groupby.epinephelinae.column.GroupByColumnSelectorPlus;
import org.apache.druid.query.groupby.epinephelinae.column.GroupByColumnSelectorStrategy;
import org.apache.druid.query.groupby.epinephelinae.column.LongGroupByColumnSelectorStrategy;
import org.apache.druid.query.groupby.epinephelinae.column.NullableNumericGroupByColumnSelectorStrategy;
import org.apache.druid.query.groupby.epinephelinae.column.StringGroupByColumnSelectorStrategy;
import org.apache.druid.query.groupby.epinephelinae.vector.VectorGroupByEngine;
import org.apache.druid.query.groupby.orderby.DefaultLimitSpec;
import org.apache.druid.query.ordering.StringComparator;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.filter.Filters;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class GroupByQueryEngineV2 {
    private static final GroupByStrategyFactory STRATEGY_FACTORY = new GroupByStrategyFactory();

    private static GroupByColumnSelectorPlus[] createGroupBySelectorPlus(ColumnSelectorPlus<GroupByColumnSelectorStrategy>[] baseSelectorPlus, int dimensionStart) {
        GroupByColumnSelectorPlus[] retInfo = new GroupByColumnSelectorPlus[baseSelectorPlus.length];
        int curPos = 0;
        for (int i = 0; i < retInfo.length; ++i) {
            retInfo[i] = new GroupByColumnSelectorPlus(baseSelectorPlus[i], curPos, dimensionStart + i);
            curPos += ((GroupByColumnSelectorStrategy)retInfo[i].getColumnSelectorStrategy()).getGroupingKeySize();
        }
        return retInfo;
    }

    private GroupByQueryEngineV2() {
    }

    public static Sequence<ResultRow> process(GroupByQuery query, @Nullable StorageAdapter storageAdapter, NonBlockingPool<ByteBuffer> intermediateResultsBufferPool, GroupByQueryConfig querySpecificConfig, QueryConfig queryConfig) {
        if (storageAdapter == null) {
            throw new ISE("Null storage adapter found. Probably trying to issue a query against a segment being memory unmapped.", new Object[0]);
        }
        List<Interval> intervals = query.getQuerySegmentSpec().getIntervals();
        if (intervals.size() != 1) {
            throw new IAE("Should only have one interval, got[%s]", new Object[]{intervals});
        }
        ResourceHolder bufferHolder = intermediateResultsBufferPool.take();
        String fudgeTimestampString = NullHandling.emptyToNullIfNeeded((String)query.getContextValue("fudgeTimestamp", null));
        DateTime fudgeTimestamp = fudgeTimestampString == null ? null : DateTimes.utc((long)Long.parseLong(fudgeTimestampString));
        Filter filter = Filters.convertToCNFFromQueryContext(query, Filters.toFilter(query.getFilter()));
        Interval interval = (Interval)Iterables.getOnlyElement(query.getIntervals());
        boolean doVectorize = queryConfig.getVectorize().shouldVectorize(VectorGroupByEngine.canVectorize(query, storageAdapter, filter));
        Sequence<ResultRow> result = doVectorize ? VectorGroupByEngine.process(query, storageAdapter, (ByteBuffer)bufferHolder.get(), fudgeTimestamp, filter, interval, querySpecificConfig, queryConfig) : GroupByQueryEngineV2.processNonVectorized(query, storageAdapter, (ByteBuffer)bufferHolder.get(), fudgeTimestamp, querySpecificConfig, filter, interval);
        return result.withBaggage((Closeable)bufferHolder);
    }

    private static Sequence<ResultRow> processNonVectorized(GroupByQuery query, StorageAdapter storageAdapter, ByteBuffer processingBuffer, @Nullable DateTime fudgeTimestamp, GroupByQueryConfig querySpecificConfig, @Nullable Filter filter, Interval interval) {
        Sequence<Cursor> cursors = storageAdapter.makeCursors(filter, interval, query.getVirtualColumns(), query.getGranularity(), false, null);
        return cursors.flatMap(cursor -> new BaseSequence(new BaseSequence.IteratorMaker<ResultRow, GroupByEngineIterator<?>>((Cursor)cursor, query, querySpecificConfig, storageAdapter, processingBuffer, fudgeTimestamp){
            final /* synthetic */ Cursor val$cursor;
            final /* synthetic */ GroupByQuery val$query;
            final /* synthetic */ GroupByQueryConfig val$querySpecificConfig;
            final /* synthetic */ StorageAdapter val$storageAdapter;
            final /* synthetic */ ByteBuffer val$processingBuffer;
            final /* synthetic */ DateTime val$fudgeTimestamp;
            {
                this.val$cursor = cursor;
                this.val$query = groupByQuery;
                this.val$querySpecificConfig = groupByQueryConfig;
                this.val$storageAdapter = storageAdapter;
                this.val$processingBuffer = byteBuffer;
                this.val$fudgeTimestamp = dateTime;
            }

            public GroupByEngineIterator make() {
                ColumnSelectorFactory columnSelectorFactory = this.val$cursor.getColumnSelectorFactory();
                ColumnSelectorPlus[] selectorPlus = DimensionHandlerUtils.createColumnSelectorPluses(STRATEGY_FACTORY, this.val$query.getDimensions(), columnSelectorFactory);
                GroupByColumnSelectorPlus[] dims = GroupByQueryEngineV2.createGroupBySelectorPlus(selectorPlus, this.val$query.getResultRowDimensionStart());
                int cardinalityForArrayAggregation = GroupByQueryEngineV2.getCardinalityForArrayAggregation(this.val$querySpecificConfig, this.val$query, this.val$storageAdapter, this.val$processingBuffer);
                if (cardinalityForArrayAggregation >= 0) {
                    return new ArrayAggregateIterator(this.val$query, this.val$querySpecificConfig, this.val$cursor, this.val$processingBuffer, this.val$fudgeTimestamp, dims, GroupByQueryEngineV2.isAllSingleValueDims(columnSelectorFactory::getColumnCapabilities, this.val$query.getDimensions()), cardinalityForArrayAggregation);
                }
                return new HashAggregateIterator(this.val$query, this.val$querySpecificConfig, this.val$cursor, this.val$processingBuffer, this.val$fudgeTimestamp, dims, GroupByQueryEngineV2.isAllSingleValueDims(columnSelectorFactory::getColumnCapabilities, this.val$query.getDimensions()));
            }

            public void cleanup(GroupByEngineIterator iterFromMake) {
                iterFromMake.close();
            }
        }));
    }

    public static int getCardinalityForArrayAggregation(GroupByQueryConfig querySpecificConfig, GroupByQuery query, StorageAdapter storageAdapter, ByteBuffer buffer) {
        int cardinality;
        ColumnCapabilities columnCapabilities;
        if (querySpecificConfig.isForceHashAggregation()) {
            return -1;
        }
        List<DimensionSpec> dimensions = query.getDimensions();
        if (dimensions.isEmpty()) {
            columnCapabilities = null;
            cardinality = 1;
        } else if (dimensions.size() == 1) {
            if (query.getVirtualColumns().exists(((DimensionSpec)Iterables.getOnlyElement(dimensions)).getDimension())) {
                return -1;
            }
            String columnName = ((DimensionSpec)Iterables.getOnlyElement(dimensions)).getDimension();
            columnCapabilities = storageAdapter.getColumnCapabilities(columnName);
            cardinality = storageAdapter.getDimensionCardinality(columnName);
        } else {
            return -1;
        }
        if (columnCapabilities != null && columnCapabilities.getType().equals((Object)ValueType.STRING) && cardinality > 0) {
            AggregatorFactory[] aggregatorFactories = query.getAggregatorSpecs().toArray(new AggregatorFactory[0]);
            long requiredBufferCapacity = BufferArrayGrouper.requiredBufferCapacity(cardinality, aggregatorFactories);
            return requiredBufferCapacity <= (long)buffer.capacity() ? cardinality : -1;
        }
        return -1;
    }

    public static boolean isAllSingleValueDims(Function<String, ColumnCapabilities> capabilitiesFunction, List<DimensionSpec> dimensions) {
        return dimensions.stream().allMatch(dimension -> {
            if (dimension.mustDecorate()) {
                return false;
            }
            ColumnCapabilities columnCapabilities = (ColumnCapabilities)capabilitiesFunction.apply(dimension.getDimension());
            return columnCapabilities == null || !columnCapabilities.hasMultipleValues();
        });
    }

    public static void convertRowTypesToOutputTypes(List<DimensionSpec> dimensionSpecs, ResultRow resultRow, int resultRowDimensionStart) {
        for (int i = 0; i < dimensionSpecs.size(); ++i) {
            DimensionSpec dimSpec = dimensionSpecs.get(i);
            int resultRowIndex = resultRowDimensionStart + i;
            ValueType outputType = dimSpec.getOutputType();
            resultRow.set(resultRowIndex, DimensionHandlerUtils.convertObjectToType(resultRow.get(resultRowIndex), outputType));
        }
    }

    private static class GroupByEngineKeySerde
    implements Grouper.KeySerde<ByteBuffer> {
        private final int keySize;
        private final GroupByColumnSelectorPlus[] dims;
        private final GroupByQuery query;

        public GroupByEngineKeySerde(GroupByColumnSelectorPlus[] dims, GroupByQuery query) {
            this.dims = dims;
            int keySize = 0;
            for (GroupByColumnSelectorPlus selectorPlus : dims) {
                keySize += ((GroupByColumnSelectorStrategy)selectorPlus.getColumnSelectorStrategy()).getGroupingKeySize();
            }
            this.keySize = keySize;
            this.query = query;
        }

        @Override
        public int keySize() {
            return this.keySize;
        }

        @Override
        public Class<ByteBuffer> keyClazz() {
            return ByteBuffer.class;
        }

        @Override
        public List<String> getDictionary() {
            return ImmutableList.of();
        }

        @Override
        public ByteBuffer toByteBuffer(ByteBuffer key) {
            return key;
        }

        @Override
        public ByteBuffer fromByteBuffer(ByteBuffer buffer, int position) {
            ByteBuffer dup = buffer.duplicate();
            dup.position(position).limit(position + this.keySize);
            return dup.slice();
        }

        @Override
        public Grouper.BufferComparator bufferComparator() {
            Preconditions.checkState((boolean)this.query.isApplyLimitPushDown(), (Object)"no limit push down");
            DefaultLimitSpec limitSpec = (DefaultLimitSpec)this.query.getLimitSpec();
            return GrouperBufferComparatorUtils.bufferComparator(this.query.getResultRowHasTimestamp(), this.query.getContextSortByDimsFirst(), this.query.getDimensions().size(), this.getDimensionComparators(limitSpec));
        }

        @Override
        public Grouper.BufferComparator bufferComparatorWithAggregators(AggregatorFactory[] aggregatorFactories, int[] aggregatorOffsets) {
            Preconditions.checkState((boolean)this.query.isApplyLimitPushDown(), (Object)"no limit push down");
            DefaultLimitSpec limitSpec = (DefaultLimitSpec)this.query.getLimitSpec();
            return GrouperBufferComparatorUtils.bufferComparatorWithAggregators(this.query.getAggregatorSpecs().toArray(new AggregatorFactory[0]), aggregatorOffsets, limitSpec, this.query.getDimensions(), this.getDimensionComparators(limitSpec), this.query.getResultRowHasTimestamp(), this.query.getContextSortByDimsFirst());
        }

        private Grouper.BufferComparator[] getDimensionComparators(DefaultLimitSpec limitSpec) {
            Grouper.BufferComparator[] dimComparators = new Grouper.BufferComparator[this.dims.length];
            for (int i = 0; i < this.dims.length; ++i) {
                String dimName = this.query.getDimensions().get(i).getOutputName();
                StringComparator stringComparator = DefaultLimitSpec.getComparatorForDimName(limitSpec, dimName);
                dimComparators[i] = ((GroupByColumnSelectorStrategy)this.dims[i].getColumnSelectorStrategy()).bufferComparator(this.dims[i].getKeyBufferPosition(), stringComparator);
            }
            return dimComparators;
        }

        @Override
        public void reset() {
        }
    }

    private static class ArrayAggregateIterator
    extends GroupByEngineIterator<Integer> {
        private final int cardinality;
        @Nullable
        private final GroupByColumnSelectorPlus dim;
        @Nullable
        private IndexedInts multiValues;
        private int nextValIndex;

        public ArrayAggregateIterator(GroupByQuery query, GroupByQueryConfig querySpecificConfig, Cursor cursor, ByteBuffer buffer, @Nullable DateTime fudgeTimestamp, GroupByColumnSelectorPlus[] dims, boolean allSingleValueDims, int cardinality) {
            super(query, querySpecificConfig, cursor, buffer, fudgeTimestamp, dims, allSingleValueDims);
            this.cardinality = cardinality;
            if (dims.length == 1) {
                this.dim = dims[0];
            } else if (dims.length == 0) {
                this.dim = null;
            } else {
                throw new IAE("Group key should be a single dimension", new Object[0]);
            }
        }

        protected IntGrouper newGrouper() {
            return new BufferArrayGrouper((Supplier<ByteBuffer>)Suppliers.ofInstance((Object)this.buffer), AggregatorAdapters.factorizeBuffered(this.cursor.getColumnSelectorFactory(), this.query.getAggregatorSpecs()), this.cardinality);
        }

        @Override
        protected void aggregateSingleValueDims(Grouper<Integer> grouper) {
            this.aggregateSingleValueDims((IntGrouper)grouper);
        }

        @Override
        protected void aggregateMultiValueDims(Grouper<Integer> grouper) {
            this.aggregateMultiValueDims((IntGrouper)grouper);
        }

        private void aggregateSingleValueDims(IntGrouper grouper) {
            while (!this.cursor.isDone()) {
                int key;
                if (this.dim != null) {
                    IndexedInts indexedInts = ((DimensionSelector)this.dim.getSelector()).getRow();
                    key = this.getSingleValue(indexedInts);
                } else {
                    key = 0;
                }
                if (!grouper.aggregate(key).isOk()) {
                    return;
                }
                this.cursor.advance();
            }
        }

        private void aggregateMultiValueDims(IntGrouper grouper) {
            if (this.dim == null) {
                throw new ISE("dim must exist", new Object[0]);
            }
            if (this.multiValues == null) {
                this.multiValues = ((DimensionSelector)this.dim.getSelector()).getRow();
                this.nextValIndex = 0;
            }
            while (!this.cursor.isDone()) {
                int multiValuesSize = this.multiValues.size();
                if (multiValuesSize == 0) {
                    if (!grouper.aggregate(-1).isOk()) {
                        return;
                    }
                } else {
                    while (this.nextValIndex < multiValuesSize) {
                        if (!grouper.aggregate(this.multiValues.get(this.nextValIndex)).isOk()) {
                            return;
                        }
                        ++this.nextValIndex;
                    }
                }
                this.cursor.advance();
                if (this.cursor.isDone()) continue;
                this.multiValues = ((DimensionSelector)this.dim.getSelector()).getRow();
                this.nextValIndex = this.multiValues.size() == 0 ? -1 : 0;
            }
        }

        @Override
        protected void putToRow(Integer key, ResultRow resultRow) {
            if (this.dim != null) {
                if (key != -1) {
                    resultRow.set(this.dim.getResultRowPosition(), ((DimensionSelector)this.dim.getSelector()).lookupName(key));
                } else {
                    resultRow.set(this.dim.getResultRowPosition(), NullHandling.defaultStringValue());
                }
            }
        }
    }

    private static class HashAggregateIterator
    extends GroupByEngineIterator<ByteBuffer> {
        private static final Logger LOGGER = new Logger(HashAggregateIterator.class);
        private final int[] stack;
        private final Object[] valuess;
        private final ByteBuffer keyBuffer;
        private int stackPointer = Integer.MIN_VALUE;
        protected boolean currentRowWasPartiallyAggregated = false;

        public HashAggregateIterator(GroupByQuery query, GroupByQueryConfig querySpecificConfig, Cursor cursor, ByteBuffer buffer, @Nullable DateTime fudgeTimestamp, GroupByColumnSelectorPlus[] dims, boolean allSingleValueDims) {
            super(query, querySpecificConfig, cursor, buffer, fudgeTimestamp, dims, allSingleValueDims);
            int dimCount = query.getDimensions().size();
            this.stack = new int[dimCount];
            this.valuess = new Object[dimCount];
            this.keyBuffer = ByteBuffer.allocate(this.keySerde.keySize());
        }

        @Override
        protected Grouper<ByteBuffer> newGrouper() {
            DefaultLimitSpec limitSpec;
            AbstractBufferHashGrouper grouper = null;
            DefaultLimitSpec defaultLimitSpec = limitSpec = this.query.isApplyLimitPushDown() && this.querySpecificConfig.isApplyLimitPushDownToSegment() ? (DefaultLimitSpec)this.query.getLimitSpec() : null;
            if (limitSpec != null) {
                LimitedBufferHashGrouper limitGrouper = new LimitedBufferHashGrouper((Supplier<ByteBuffer>)Suppliers.ofInstance((Object)this.buffer), this.keySerde, AggregatorAdapters.factorizeBuffered(this.cursor.getColumnSelectorFactory(), this.query.getAggregatorSpecs()), this.querySpecificConfig.getBufferGrouperMaxSize(), this.querySpecificConfig.getBufferGrouperMaxLoadFactor(), this.querySpecificConfig.getBufferGrouperInitialBuckets(), limitSpec.getLimit(), DefaultLimitSpec.sortingOrderHasNonGroupingFields(limitSpec, this.query.getDimensions()));
                if (limitGrouper.validateBufferCapacity(this.buffer.capacity())) {
                    grouper = limitGrouper;
                } else {
                    LOGGER.warn("Limit is not applied in segment scan phase due to limited buffer capacity for query [%s].", new Object[]{this.query.getId()});
                }
            }
            if (grouper == null) {
                grouper = new BufferHashGrouper((Supplier<ByteBuffer>)Suppliers.ofInstance((Object)this.buffer), this.keySerde, AggregatorAdapters.factorizeBuffered(this.cursor.getColumnSelectorFactory(), this.query.getAggregatorSpecs()), this.querySpecificConfig.getBufferGrouperMaxSize(), this.querySpecificConfig.getBufferGrouperMaxLoadFactor(), this.querySpecificConfig.getBufferGrouperInitialBuckets(), true);
            }
            return grouper;
        }

        @Override
        protected void aggregateSingleValueDims(Grouper<ByteBuffer> grouper) {
            while (!this.cursor.isDone()) {
                for (GroupByColumnSelectorPlus dim : this.dims) {
                    GroupByColumnSelectorStrategy strategy = (GroupByColumnSelectorStrategy)dim.getColumnSelectorStrategy();
                    strategy.writeToKeyBuffer(dim.getKeyBufferPosition(), strategy.getOnlyValue(dim.getSelector()), this.keyBuffer);
                }
                this.keyBuffer.rewind();
                if (!grouper.aggregate(this.keyBuffer).isOk()) {
                    return;
                }
                this.cursor.advance();
            }
        }

        @Override
        protected void aggregateMultiValueDims(Grouper<ByteBuffer> grouper) {
            while (!this.cursor.isDone()) {
                if (!this.currentRowWasPartiallyAggregated) {
                    this.stackPointer = this.stack.length - 1;
                    for (int i = 0; i < this.dims.length; ++i) {
                        GroupByColumnSelectorStrategy strategy = (GroupByColumnSelectorStrategy)this.dims[i].getColumnSelectorStrategy();
                        strategy.initColumnValues(this.dims[i].getSelector(), i, this.valuess);
                        strategy.initGroupingKeyColumnValue(this.dims[i].getKeyBufferPosition(), i, this.valuess[i], this.keyBuffer, this.stack);
                    }
                }
                boolean doAggregate = true;
                while (this.stackPointer >= -1) {
                    if (doAggregate) {
                        this.keyBuffer.rewind();
                        if (!grouper.aggregate(this.keyBuffer).isOk()) {
                            this.currentRowWasPartiallyAggregated = true;
                            return;
                        }
                        doAggregate = false;
                    }
                    if (this.stackPointer >= 0) {
                        doAggregate = ((GroupByColumnSelectorStrategy)this.dims[this.stackPointer].getColumnSelectorStrategy()).checkRowIndexAndAddValueToGroupingKey(this.dims[this.stackPointer].getKeyBufferPosition(), this.valuess[this.stackPointer], this.stack[this.stackPointer], this.keyBuffer);
                        if (doAggregate) {
                            int n = this.stackPointer;
                            this.stack[n] = this.stack[n] + 1;
                            for (int i = this.stackPointer + 1; i < this.stack.length; ++i) {
                                ((GroupByColumnSelectorStrategy)this.dims[i].getColumnSelectorStrategy()).initGroupingKeyColumnValue(this.dims[i].getKeyBufferPosition(), i, this.valuess[i], this.keyBuffer, this.stack);
                            }
                            this.stackPointer = this.stack.length - 1;
                            continue;
                        }
                        --this.stackPointer;
                        continue;
                    }
                    --this.stackPointer;
                }
                this.cursor.advance();
                this.currentRowWasPartiallyAggregated = false;
            }
        }

        @Override
        protected void putToRow(ByteBuffer key, ResultRow resultRow) {
            for (GroupByColumnSelectorPlus selectorPlus : this.dims) {
                ((GroupByColumnSelectorStrategy)selectorPlus.getColumnSelectorStrategy()).processValueFromGroupingKey(selectorPlus, key, resultRow, selectorPlus.getKeyBufferPosition());
            }
        }
    }

    private static abstract class GroupByEngineIterator<KeyType>
    implements Iterator<ResultRow>,
    Closeable {
        protected final GroupByQuery query;
        protected final GroupByQueryConfig querySpecificConfig;
        protected final Cursor cursor;
        protected final ByteBuffer buffer;
        protected final Grouper.KeySerde<ByteBuffer> keySerde;
        protected final GroupByColumnSelectorPlus[] dims;
        protected final DateTime timestamp;
        @Nullable
        protected CloseableGrouperIterator<KeyType, ResultRow> delegate = null;
        protected final boolean allSingleValueDims;

        public GroupByEngineIterator(GroupByQuery query, GroupByQueryConfig querySpecificConfig, Cursor cursor, ByteBuffer buffer, @Nullable DateTime fudgeTimestamp, GroupByColumnSelectorPlus[] dims, boolean allSingleValueDims) {
            this.query = query;
            this.querySpecificConfig = querySpecificConfig;
            this.cursor = cursor;
            this.buffer = buffer;
            this.keySerde = new GroupByEngineKeySerde(dims, query);
            this.dims = dims;
            this.timestamp = fudgeTimestamp != null ? fudgeTimestamp : cursor.getTime();
            this.allSingleValueDims = allSingleValueDims;
        }

        private CloseableGrouperIterator<KeyType, ResultRow> initNewDelegate() {
            Grouper<KeyType> grouper = this.newGrouper();
            grouper.init();
            if (this.allSingleValueDims) {
                this.aggregateSingleValueDims(grouper);
            } else {
                this.aggregateMultiValueDims(grouper);
            }
            boolean resultRowHasTimestamp = this.query.getResultRowHasTimestamp();
            int resultRowDimensionStart = this.query.getResultRowDimensionStart();
            int resultRowAggregatorStart = this.query.getResultRowAggregatorStart();
            return new CloseableGrouperIterator<KeyType, ResultRow>(grouper.iterator(false), entry -> {
                ResultRow resultRow = ResultRow.create(this.query.getResultRowSizeWithoutPostAggregators());
                if (resultRowHasTimestamp) {
                    resultRow.set(0, this.timestamp.getMillis());
                }
                this.putToRow(entry.getKey(), resultRow);
                GroupByQueryEngineV2.convertRowTypesToOutputTypes(this.query.getDimensions(), resultRow, resultRowDimensionStart);
                for (int i = 0; i < entry.getValues().length; ++i) {
                    resultRow.set(resultRowAggregatorStart + i, entry.getValues()[i]);
                }
                return resultRow;
            }, grouper);
        }

        @Override
        public ResultRow next() {
            if (this.delegate == null || !this.delegate.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.delegate.next();
        }

        @Override
        public boolean hasNext() {
            if (this.delegate != null && this.delegate.hasNext()) {
                return true;
            }
            if (!this.cursor.isDone()) {
                if (this.delegate != null) {
                    this.delegate.close();
                }
                this.delegate = this.initNewDelegate();
                return this.delegate.hasNext();
            }
            return false;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() {
            if (this.delegate != null) {
                this.delegate.close();
            }
        }

        protected abstract Grouper<KeyType> newGrouper();

        protected abstract void aggregateSingleValueDims(Grouper<KeyType> var1);

        protected abstract void aggregateMultiValueDims(Grouper<KeyType> var1);

        protected abstract void putToRow(KeyType var1, ResultRow var2);

        protected int getSingleValue(IndexedInts indexedInts) {
            Preconditions.checkArgument((indexedInts.size() < 2 ? 1 : 0) != 0, (Object)"should be single value");
            return indexedInts.size() == 1 ? indexedInts.get(0) : -1;
        }
    }

    private static class GroupByStrategyFactory
    implements ColumnSelectorStrategyFactory<GroupByColumnSelectorStrategy> {
        private GroupByStrategyFactory() {
        }

        @Override
        public GroupByColumnSelectorStrategy makeColumnSelectorStrategy(ColumnCapabilities capabilities, ColumnValueSelector selector) {
            ValueType type = capabilities.getType();
            switch (type) {
                case STRING: {
                    DimensionSelector dimSelector = (DimensionSelector)selector;
                    if (dimSelector.getValueCardinality() >= 0) {
                        return new StringGroupByColumnSelectorStrategy(dimSelector::lookupName);
                    }
                    return new DictionaryBuildingStringGroupByColumnSelectorStrategy();
                }
                case LONG: {
                    return this.makeNullableNumericStrategy(new LongGroupByColumnSelectorStrategy());
                }
                case FLOAT: {
                    return this.makeNullableNumericStrategy(new FloatGroupByColumnSelectorStrategy());
                }
                case DOUBLE: {
                    return this.makeNullableNumericStrategy(new DoubleGroupByColumnSelectorStrategy());
                }
            }
            throw new IAE("Cannot create query type helper from invalid type [%s]", new Object[]{type});
        }

        private GroupByColumnSelectorStrategy makeNullableNumericStrategy(GroupByColumnSelectorStrategy delegate) {
            if (NullHandling.sqlCompatible()) {
                return new NullableNumericGroupByColumnSelectorStrategy(delegate);
            }
            return delegate;
        }
    }
}

