/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae.column;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.epinephelinae.Grouper;
import org.apache.druid.query.groupby.epinephelinae.column.GroupByColumnSelectorPlus;
import org.apache.druid.query.groupby.epinephelinae.column.GroupByColumnSelectorStrategy;
import org.apache.druid.query.ordering.StringComparator;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.data.IndexedInts;

public class StringGroupByColumnSelectorStrategy
implements GroupByColumnSelectorStrategy {
    @Nullable
    private final IntFunction<String> dictionaryLookup;

    public StringGroupByColumnSelectorStrategy(IntFunction<String> dictionaryLookup) {
        this.dictionaryLookup = dictionaryLookup;
    }

    @Override
    public int getGroupingKeySize() {
        return 4;
    }

    @Override
    public void processValueFromGroupingKey(GroupByColumnSelectorPlus selectorPlus, ByteBuffer key, ResultRow resultRow, int keyBufferPosition) {
        int id = key.getInt(keyBufferPosition);
        if (id != -1) {
            resultRow.set(selectorPlus.getResultRowPosition(), ((DimensionSelector)selectorPlus.getSelector()).lookupName(id));
        } else {
            resultRow.set(selectorPlus.getResultRowPosition(), NullHandling.defaultStringValue());
        }
    }

    @Override
    public void initColumnValues(ColumnValueSelector selector, int columnIndex, Object[] valuess) {
        DimensionSelector dimSelector = (DimensionSelector)selector;
        IndexedInts row = dimSelector.getRow();
        valuess[columnIndex] = row;
    }

    @Override
    public Object getOnlyValue(ColumnValueSelector selector) {
        DimensionSelector dimSelector = (DimensionSelector)selector;
        IndexedInts row = dimSelector.getRow();
        Preconditions.checkState((row.size() < 2 ? 1 : 0) != 0, (Object)"Not supported for multi-value dimensions");
        return row.size() == 1 ? row.get(0) : -1;
    }

    @Override
    public void writeToKeyBuffer(int keyBufferPosition, Object obj, ByteBuffer keyBuffer) {
        keyBuffer.putInt(keyBufferPosition, (Integer)obj);
    }

    @Override
    public void initGroupingKeyColumnValue(int keyBufferPosition, int columnIndex, Object rowObj, ByteBuffer keyBuffer, int[] stack) {
        IndexedInts row = (IndexedInts)rowObj;
        int rowSize = row.size();
        this.initializeGroupingKeyV2Dimension(row, rowSize, keyBuffer, keyBufferPosition);
        stack[columnIndex] = rowSize == 0 ? 0 : 1;
    }

    @Override
    public boolean checkRowIndexAndAddValueToGroupingKey(int keyBufferPosition, Object rowObj, int rowValIdx, ByteBuffer keyBuffer) {
        IndexedInts row = (IndexedInts)rowObj;
        int rowSize = row.size();
        if (rowValIdx < rowSize) {
            keyBuffer.putInt(keyBufferPosition, row.get(rowValIdx));
            return true;
        }
        return false;
    }

    private void initializeGroupingKeyV2Dimension(IndexedInts values, int rowSize, ByteBuffer keyBuffer, int keyBufferPosition) {
        if (rowSize == 0) {
            keyBuffer.putInt(keyBufferPosition, -1);
        } else {
            keyBuffer.putInt(keyBufferPosition, values.get(0));
        }
    }

    @Override
    public Grouper.BufferComparator bufferComparator(int keyBufferPosition, @Nullable StringComparator stringComparator) {
        if (stringComparator == null || StringComparators.LEXICOGRAPHIC.equals(stringComparator)) {
            return (lhsBuffer, rhsBuffer, lhsPosition, rhsPosition) -> Integer.compare(lhsBuffer.getInt(lhsPosition + keyBufferPosition), rhsBuffer.getInt(rhsPosition + keyBufferPosition));
        }
        Preconditions.checkState((this.dictionaryLookup != null ? 1 : 0) != 0, (Object)"null dictionary lookup");
        return (lhsBuffer, rhsBuffer, lhsPosition, rhsPosition) -> {
            String lhsStr = this.dictionaryLookup.apply(lhsBuffer.getInt(lhsPosition + keyBufferPosition));
            String rhsStr = this.dictionaryLookup.apply(rhsBuffer.getInt(rhsPosition + keyBufferPosition));
            return stringComparator.compare(lhsStr, rhsStr);
        };
    }
}

