/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae.vector;

import java.nio.ByteBuffer;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.epinephelinae.vector.GroupByVectorColumnSelector;
import org.apache.druid.segment.vector.VectorValueSelector;

public class FloatGroupByVectorColumnSelector
implements GroupByVectorColumnSelector {
    private final VectorValueSelector selector;

    FloatGroupByVectorColumnSelector(VectorValueSelector selector) {
        this.selector = selector;
    }

    @Override
    public int getGroupingKeySize() {
        return 1;
    }

    @Override
    public void writeKeys(int[] keySpace, int keySize, int keyOffset, int startRow, int endRow) {
        float[] vector = this.selector.getFloatVector();
        int i = startRow;
        int j = keyOffset;
        while (i < endRow) {
            keySpace[j] = Float.floatToIntBits(vector[i]);
            ++i;
            j += keySize;
        }
    }

    @Override
    public void writeKeyToResultRow(ByteBuffer keyBuffer, int keyOffset, ResultRow resultRow, int resultRowPosition) {
        float value = Float.intBitsToFloat(keyBuffer.getInt(keyOffset * 4));
        resultRow.set(resultRowPosition, Float.valueOf(value));
    }
}

