/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.orderby;

import com.google.common.collect.MinMaxPriorityQueue;
import com.google.common.collect.Ordering;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.druid.java.util.common.guava.Accumulator;
import org.apache.druid.java.util.common.guava.BaseSequence;
import org.apache.druid.java.util.common.guava.Sequence;

public class TopNSequence<T>
extends BaseSequence<T, Iterator<T>> {
    public TopNSequence(final Sequence<T> input, final Ordering<T> ordering, final int limit) {
        super(new BaseSequence.IteratorMaker<T, Iterator<T>>(){

            public Iterator<T> make() {
                if (limit <= 0) {
                    return Collections.emptyIterator();
                }
                final MinMaxPriorityQueue queue = MinMaxPriorityQueue.orderedBy((Comparator)ordering).maximumSize(limit).create();
                input.accumulate((Object)queue, new Accumulator<MinMaxPriorityQueue<T>, T>(){

                    public MinMaxPriorityQueue<T> accumulate(MinMaxPriorityQueue<T> theQueue, T row) {
                        theQueue.offer(row);
                        return theQueue;
                    }
                });
                return new Iterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return !queue.isEmpty();
                    }

                    @Override
                    public T next() {
                        return queue.poll();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            public void cleanup(Iterator<T> rowIterator) {
            }
        });
    }
}

