/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.timeseries;

import com.google.inject.Inject;
import java.util.concurrent.ExecutorService;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.query.ChainedExecutionQueryRunner;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerFactory;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.QueryWatcher;
import org.apache.druid.query.Result;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.query.timeseries.TimeseriesQueryEngine;
import org.apache.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import org.apache.druid.query.timeseries.TimeseriesResultValue;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.StorageAdapter;

public class TimeseriesQueryRunnerFactory
implements QueryRunnerFactory<Result<TimeseriesResultValue>, TimeseriesQuery> {
    private final TimeseriesQueryQueryToolChest toolChest;
    private final TimeseriesQueryEngine engine;
    private final QueryWatcher queryWatcher;

    @Inject
    public TimeseriesQueryRunnerFactory(TimeseriesQueryQueryToolChest toolChest, TimeseriesQueryEngine engine, QueryWatcher queryWatcher) {
        this.toolChest = toolChest;
        this.engine = engine;
        this.queryWatcher = queryWatcher;
    }

    @Override
    public QueryRunner<Result<TimeseriesResultValue>> createRunner(Segment segment) {
        return new TimeseriesQueryRunner(this.engine, segment.asStorageAdapter());
    }

    @Override
    public QueryRunner<Result<TimeseriesResultValue>> mergeRunners(ExecutorService queryExecutor, Iterable<QueryRunner<Result<TimeseriesResultValue>>> queryRunners) {
        return new ChainedExecutionQueryRunner<Result<TimeseriesResultValue>>(queryExecutor, this.queryWatcher, queryRunners);
    }

    @Override
    public QueryToolChest<Result<TimeseriesResultValue>, TimeseriesQuery> getToolchest() {
        return this.toolChest;
    }

    private static class TimeseriesQueryRunner
    implements QueryRunner<Result<TimeseriesResultValue>> {
        private final TimeseriesQueryEngine engine;
        private final StorageAdapter adapter;

        private TimeseriesQueryRunner(TimeseriesQueryEngine engine, StorageAdapter adapter) {
            this.engine = engine;
            this.adapter = adapter;
        }

        @Override
        public Sequence<Result<TimeseriesResultValue>> run(QueryPlus<Result<TimeseriesResultValue>> queryPlus, ResponseContext responseContext) {
            Query<Result<TimeseriesResultValue>> input = queryPlus.getQuery();
            if (!(input instanceof TimeseriesQuery)) {
                throw new ISE("Got a [%s] which isn't a %s", new Object[]{input.getClass(), TimeseriesQuery.class});
            }
            return this.engine.process((TimeseriesQuery)input, this.adapter);
        }
    }
}

