/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.topn;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.InDimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.query.spec.LegacySegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.query.topn.NumericTopNMetricSpec;
import org.apache.druid.query.topn.TopNMetricSpec;
import org.apache.druid.query.topn.TopNQuery;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.joda.time.Interval;

public class TopNQueryBuilder {
    private DataSource dataSource;
    private VirtualColumns virtualColumns;
    private DimensionSpec dimensionSpec;
    private TopNMetricSpec topNMetricSpec;
    private int threshold;
    private QuerySegmentSpec querySegmentSpec;
    private DimFilter dimFilter;
    private Granularity granularity;
    private List<AggregatorFactory> aggregatorSpecs;
    private List<PostAggregator> postAggregatorSpecs;
    private Map<String, Object> context;

    public TopNQueryBuilder() {
        this.dataSource = null;
        this.virtualColumns = null;
        this.dimensionSpec = null;
        this.topNMetricSpec = null;
        this.threshold = 0;
        this.querySegmentSpec = null;
        this.dimFilter = null;
        this.granularity = Granularities.ALL;
        this.aggregatorSpecs = new ArrayList<AggregatorFactory>();
        this.postAggregatorSpecs = new ArrayList<PostAggregator>();
        this.context = null;
    }

    public TopNQueryBuilder(TopNQuery query) {
        this.dataSource = query.getDataSource();
        this.virtualColumns = query.getVirtualColumns();
        this.dimensionSpec = query.getDimensionSpec();
        this.topNMetricSpec = query.getTopNMetricSpec();
        this.threshold = query.getThreshold();
        this.querySegmentSpec = query.getQuerySegmentSpec();
        this.dimFilter = query.getDimensionsFilter();
        this.granularity = query.getGranularity();
        this.aggregatorSpecs = query.getAggregatorSpecs();
        this.postAggregatorSpecs = query.getPostAggregatorSpecs();
        this.context = query.getContext();
    }

    public TopNQuery build() {
        return new TopNQuery(this.dataSource, this.virtualColumns, this.dimensionSpec, this.topNMetricSpec, this.threshold, this.querySegmentSpec, this.dimFilter, this.granularity, this.aggregatorSpecs, this.postAggregatorSpecs, this.context);
    }

    @Deprecated
    public TopNQueryBuilder copy(TopNQuery query) {
        return new TopNQueryBuilder(query);
    }

    @Deprecated
    public TopNQueryBuilder copy(TopNQueryBuilder builder) {
        return new TopNQueryBuilder().dataSource(builder.dataSource).virtualColumns(builder.virtualColumns).dimension(builder.dimensionSpec).metric(builder.topNMetricSpec).threshold(builder.threshold).intervals(builder.querySegmentSpec).filters(builder.dimFilter).granularity(builder.granularity).aggregators(builder.aggregatorSpecs).postAggregators(builder.postAggregatorSpecs).context(builder.context);
    }

    public TopNQueryBuilder dataSource(String d) {
        this.dataSource = new TableDataSource(d);
        return this;
    }

    public TopNQueryBuilder virtualColumns(VirtualColumns virtualColumns) {
        this.virtualColumns = virtualColumns;
        return this;
    }

    public TopNQueryBuilder virtualColumns(VirtualColumn ... virtualColumns) {
        return this.virtualColumns(VirtualColumns.create(Arrays.asList(virtualColumns)));
    }

    public TopNQueryBuilder dataSource(DataSource d) {
        this.dataSource = d;
        return this;
    }

    public TopNQueryBuilder dimension(String d) {
        return this.dimension(d, null);
    }

    public TopNQueryBuilder dimension(String d, String outputName) {
        return this.dimension(new DefaultDimensionSpec(d, outputName));
    }

    public TopNQueryBuilder dimension(DimensionSpec d) {
        this.dimensionSpec = d;
        return this;
    }

    public TopNQueryBuilder metric(String s) {
        return this.metric(new NumericTopNMetricSpec(s));
    }

    public TopNQueryBuilder metric(TopNMetricSpec t) {
        this.topNMetricSpec = t;
        return this;
    }

    public TopNQueryBuilder threshold(int i) {
        this.threshold = i;
        return this;
    }

    public TopNQueryBuilder intervals(QuerySegmentSpec q) {
        this.querySegmentSpec = q;
        return this;
    }

    public TopNQueryBuilder intervals(String s) {
        this.querySegmentSpec = new LegacySegmentSpec(s);
        return this;
    }

    public TopNQueryBuilder intervals(List<Interval> l) {
        this.querySegmentSpec = new LegacySegmentSpec((Object)l);
        return this;
    }

    public TopNQueryBuilder filters(String dimensionName, String value) {
        this.dimFilter = new SelectorDimFilter(dimensionName, value, null);
        return this;
    }

    public TopNQueryBuilder filters(String dimensionName, String value, String ... values) {
        this.dimFilter = new InDimFilter(dimensionName, Lists.asList((Object)value, (Object[])values), null, null);
        return this;
    }

    public TopNQueryBuilder filters(DimFilter f) {
        this.dimFilter = f;
        return this;
    }

    public TopNQueryBuilder granularity(Granularity g) {
        this.granularity = g;
        return this;
    }

    public TopNQueryBuilder aggregators(List<? extends AggregatorFactory> a) {
        this.aggregatorSpecs = new ArrayList<AggregatorFactory>(a);
        return this;
    }

    public TopNQueryBuilder aggregators(AggregatorFactory ... aggs) {
        this.aggregatorSpecs = Arrays.asList(aggs);
        return this;
    }

    public TopNQueryBuilder postAggregators(Collection<PostAggregator> p) {
        this.postAggregatorSpecs = new ArrayList<PostAggregator>(p);
        return this;
    }

    public TopNQueryBuilder postAggregators(PostAggregator ... postAggs) {
        this.postAggregatorSpecs = Arrays.asList(postAggs);
        return this;
    }

    public TopNQueryBuilder context(Map<String, Object> c) {
        this.context = c;
        return this;
    }
}

