/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.ning.compress.BufferRecycler;
import com.ning.compress.lzf.LZFDecoder;
import com.ning.compress.lzf.LZFEncoder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4SafeDecompressor;
import org.apache.commons.lang.ArrayUtils;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.java.util.common.ByteBufferUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.segment.CompressedPools;

public enum CompressionStrategy {
    LZF(0){

        @Override
        public Decompressor getDecompressor() {
            return LZFDecompressor.DEFAULT_DECOMPRESSOR;
        }

        @Override
        public Compressor getCompressor() {
            return LZFCompressor.DEFAULT_COMPRESSOR;
        }
    }
    ,
    LZ4(1){

        @Override
        public Decompressor getDecompressor() {
            return LZ4Decompressor.DEFAULT_COMPRESSOR;
        }

        @Override
        public Compressor getCompressor() {
            return LZ4Compressor.DEFAULT_COMPRESSOR;
        }
    }
    ,
    UNCOMPRESSED(-1){

        @Override
        public Decompressor getDecompressor() {
            return UncompressedDecompressor.DEFAULT_DECOMPRESSOR;
        }

        @Override
        public Compressor getCompressor() {
            return UncompressedCompressor.DEFAULT_COMPRESSOR;
        }
    }
    ,
    NONE(-2){

        @Override
        public Decompressor getDecompressor() {
            throw new UnsupportedOperationException("NONE compression strategy shouldn't use any decompressor");
        }

        @Override
        public Compressor getCompressor() {
            throw new UnsupportedOperationException("NONE compression strategy shouldn't use any compressor");
        }
    };

    private static final Logger LOG;
    public static final CompressionStrategy DEFAULT_COMPRESSION_STRATEGY;
    final byte id;
    static final Map<Byte, CompressionStrategy> ID_MAP;

    private CompressionStrategy(byte id) {
        this.id = id;
    }

    public byte getId() {
        return this.id;
    }

    public abstract Compressor getCompressor();

    public abstract Decompressor getDecompressor();

    @JsonValue
    public String toString() {
        return StringUtils.toLowerCase((String)this.name());
    }

    @JsonCreator
    public static CompressionStrategy fromString(String name) {
        return CompressionStrategy.valueOf(StringUtils.toUpperCase((String)name));
    }

    public static CompressionStrategy forId(byte id) {
        return ID_MAP.get(id);
    }

    public static CompressionStrategy[] noNoneValues() {
        return (CompressionStrategy[])ArrayUtils.removeElement((Object[])CompressionStrategy.values(), (Object)((Object)NONE));
    }

    private static void logLZ4State() {
        LOG.debug("java.library.path: " + System.getProperty("java.library.path"), new Object[0]);
        LZ4Factory fastestInstance = LZ4Factory.fastestInstance();
        try {
            if (fastestInstance == LZ4Factory.nativeInstance()) {
                LOG.debug("LZ4 compression is using native instance.", new Object[0]);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (fastestInstance == LZ4Factory.unsafeInstance()) {
                LOG.debug("LZ4 compression is using unsafe instance.", new Object[0]);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (fastestInstance == LZ4Factory.safeInstance()) {
            LOG.debug("LZ4 compression is using safe instance.", new Object[0]);
        }
    }

    static {
        LOG = new Logger(CompressionStrategy.class);
        DEFAULT_COMPRESSION_STRATEGY = LZ4;
        ID_MAP = new HashMap<Byte, CompressionStrategy>();
        for (CompressionStrategy strategy : CompressionStrategy.values()) {
            ID_MAP.put(strategy.getId(), strategy);
        }
    }

    public static class LZ4Compressor
    extends Compressor {
        private static final LZ4Compressor DEFAULT_COMPRESSOR = new LZ4Compressor();
        private static final net.jpountz.lz4.LZ4Compressor LZ4_HIGH = LZ4Factory.fastestInstance().highCompressor();

        @Override
        ByteBuffer allocateInBuffer(int inputSize, Closer closer) {
            ByteBuffer inBuffer = ByteBuffer.allocateDirect(inputSize);
            closer.register(() -> ByteBufferUtils.free((ByteBuffer)inBuffer));
            return inBuffer;
        }

        @Override
        ByteBuffer allocateOutBuffer(int inputSize, Closer closer) {
            ByteBuffer outBuffer = ByteBuffer.allocateDirect(LZ4_HIGH.maxCompressedLength(inputSize));
            closer.register(() -> ByteBufferUtils.free((ByteBuffer)outBuffer));
            return outBuffer;
        }

        @Override
        public ByteBuffer compress(ByteBuffer in, ByteBuffer out) {
            out.clear();
            int position = in.position();
            LZ4_HIGH.compress(in, out);
            in.position(position);
            out.flip();
            return out;
        }

        static {
            CompressionStrategy.logLZ4State();
        }
    }

    public static class LZ4Decompressor
    implements Decompressor {
        private static final LZ4SafeDecompressor LZ4_SAFE = LZ4Factory.fastestInstance().safeDecompressor();
        private static final LZ4Decompressor DEFAULT_COMPRESSOR = new LZ4Decompressor();

        @Override
        public void decompress(ByteBuffer in, int numBytes, ByteBuffer out) {
            int numDecompressedBytes = LZ4_SAFE.decompress(in, in.position(), numBytes, out, out.position(), out.remaining());
            out.limit(out.position() + numDecompressedBytes);
        }
    }

    public static class LZFCompressor
    extends Compressor {
        private static final LZFCompressor DEFAULT_COMPRESSOR = new LZFCompressor();

        @Override
        public ByteBuffer allocateOutBuffer(int inputSize, Closer closer) {
            return ByteBuffer.allocate(LZFEncoder.estimateMaxWorkspaceSize((int)inputSize));
        }

        @Override
        public ByteBuffer compress(ByteBuffer in, ByteBuffer out) {
            try (ResourceHolder<BufferRecycler> bufferRecycler = CompressedPools.getBufferRecycler();){
                int encodedLen = LZFEncoder.appendEncoded((byte[])in.array(), (int)(in.arrayOffset() + in.position()), (int)in.remaining(), (byte[])out.array(), (int)out.arrayOffset(), (BufferRecycler)((BufferRecycler)bufferRecycler.get()));
                out.clear();
                out.limit(encodedLen);
                ByteBuffer byteBuffer = out;
                return byteBuffer;
            }
        }
    }

    public static class LZFDecompressor
    implements Decompressor {
        private static final LZFDecompressor DEFAULT_DECOMPRESSOR = new LZFDecompressor();

        @Override
        public void decompress(ByteBuffer in, int numBytes, ByteBuffer out) {
            byte[] bytes = new byte[numBytes];
            in.get(bytes);
            try (ResourceHolder<byte[]> outputBytesHolder = CompressedPools.getOutputBytes();){
                byte[] outputBytes = (byte[])outputBytesHolder.get();
                int numDecompressedBytes = LZFDecoder.decode((byte[])bytes, (byte[])outputBytes);
                out.put(outputBytes, 0, numDecompressedBytes);
                out.flip();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class UncompressedDecompressor
    implements Decompressor {
        private static final UncompressedDecompressor DEFAULT_DECOMPRESSOR = new UncompressedDecompressor();

        @Override
        public void decompress(ByteBuffer in, int numBytes, ByteBuffer out) {
            ByteBuffer copyBuffer = in.duplicate();
            copyBuffer.limit(copyBuffer.position() + numBytes);
            out.put(copyBuffer).flip();
            in.position(in.position() + numBytes);
        }
    }

    public static class UncompressedCompressor
    extends Compressor {
        private static final UncompressedCompressor DEFAULT_COMPRESSOR = new UncompressedCompressor();

        @Override
        ByteBuffer allocateOutBuffer(int inputSize, Closer closer) {
            return ByteBuffer.allocate(inputSize);
        }

        @Override
        public ByteBuffer compress(ByteBuffer in, ByteBuffer out) {
            return in;
        }
    }

    public static abstract class Compressor {
        ByteBuffer allocateInBuffer(int inputSize, Closer closer) {
            return ByteBuffer.allocate(inputSize);
        }

        abstract ByteBuffer allocateOutBuffer(int var1, Closer var2);

        public abstract ByteBuffer compress(ByteBuffer var1, ByteBuffer var2);
    }

    public static interface Decompressor {
        public void decompress(ByteBuffer var1, int var2, ByteBuffer var3);
    }
}

