/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import java.nio.ByteBuffer;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.ConciseBitmapFactory;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.collections.bitmap.WrappedImmutableConciseBitmap;
import org.apache.druid.extendedset.intset.ImmutableConciseSet;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.ObjectStrategy;

public class ConciseBitmapSerdeFactory
implements BitmapSerdeFactory {
    private static final ObjectStrategy<ImmutableBitmap> OBJECT_STRATEGY = new ImmutableConciseSetObjectStrategy();
    private static final BitmapFactory BITMAP_FACTORY = new ConciseBitmapFactory();

    @Override
    public ObjectStrategy<ImmutableBitmap> getObjectStrategy() {
        return OBJECT_STRATEGY;
    }

    @Override
    public BitmapFactory getBitmapFactory() {
        return BITMAP_FACTORY;
    }

    public String toString() {
        return "ConciseBitmapSerdeFactory{}";
    }

    public boolean equals(Object o) {
        return this == o || o instanceof ConciseBitmapSerdeFactory;
    }

    public int hashCode() {
        return 0;
    }

    private static class ImmutableConciseSetObjectStrategy
    implements ObjectStrategy<ImmutableBitmap> {
        private ImmutableConciseSetObjectStrategy() {
        }

        @Override
        public Class<ImmutableBitmap> getClazz() {
            return ImmutableBitmap.class;
        }

        @Override
        public WrappedImmutableConciseBitmap fromByteBuffer(ByteBuffer buffer, int numBytes) {
            buffer.limit(buffer.position() + numBytes);
            return new WrappedImmutableConciseBitmap(new ImmutableConciseSet(buffer.asIntBuffer()));
        }

        @Override
        public byte[] toBytes(ImmutableBitmap val) {
            if (val == null || val.isEmpty()) {
                return new byte[0];
            }
            return val.toBytes();
        }

        @Override
        public int compare(ImmutableBitmap o1, ImmutableBitmap o2) {
            throw new UnsupportedOperationException();
        }
    }
}

