/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import com.google.common.primitives.Ints;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.Iterator;
import org.apache.druid.common.utils.ByteUtils;
import org.apache.druid.io.Channels;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.data.ColumnarMultiInts;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.data.IndexedIterable;
import org.apache.druid.segment.data.VSizeColumnarInts;
import org.apache.druid.segment.data.WritableSupplier;
import org.apache.druid.segment.serde.MetaSerdeHelper;
import org.apache.druid.segment.writeout.HeapByteBufferWriteOutBytes;

public class VSizeColumnarMultiInts
implements ColumnarMultiInts,
WritableSupplier<ColumnarMultiInts> {
    private static final byte VERSION = 1;
    private static final MetaSerdeHelper<VSizeColumnarMultiInts> META_SERDE_HELPER = MetaSerdeHelper.firstWriteByte(x -> 1).writeByte(x -> ByteUtils.checkedCast((int)x.numBytes)).writeInt(x -> Ints.checkedCast((long)((long)x.theBuffer.remaining() + 4L))).writeInt(x -> x.size);
    private final ByteBuffer theBuffer;
    private final int numBytes;
    private final int size;
    private final int valuesOffset;
    private final int bufferBytes;

    public static VSizeColumnarMultiInts fromIterable(Iterable<VSizeColumnarInts> objectsIterable) {
        Iterator<VSizeColumnarInts> objects = objectsIterable.iterator();
        if (!objects.hasNext()) {
            ByteBuffer buffer = ByteBuffer.allocate(4).putInt(0, 0);
            return new VSizeColumnarMultiInts(buffer, 4);
        }
        int numBytes = -1;
        int count = 0;
        while (objects.hasNext()) {
            VSizeColumnarInts next = objects.next();
            if (numBytes == -1) {
                numBytes = next.getNumBytes();
            }
            ++count;
        }
        HeapByteBufferWriteOutBytes headerBytes = new HeapByteBufferWriteOutBytes();
        HeapByteBufferWriteOutBytes valueBytes = new HeapByteBufferWriteOutBytes();
        int offset = 0;
        headerBytes.writeInt(count);
        for (VSizeColumnarInts object : objectsIterable) {
            if (object.getNumBytes() != numBytes) {
                throw new ISE("val.numBytes[%s] != numBytesInValue[%s]", new Object[]{object.getNumBytes(), numBytes});
            }
            headerBytes.writeInt(offset += object.getNumBytesNoPadding());
            object.writeBytesNoPaddingTo(valueBytes);
        }
        valueBytes.write(new byte[4 - numBytes]);
        ByteBuffer theBuffer = ByteBuffer.allocate(Ints.checkedCast((long)(headerBytes.size() + valueBytes.size())));
        headerBytes.writeTo(theBuffer);
        valueBytes.writeTo(theBuffer);
        theBuffer.flip();
        return new VSizeColumnarMultiInts(theBuffer.asReadOnlyBuffer(), numBytes);
    }

    VSizeColumnarMultiInts(ByteBuffer buffer, int numBytes) {
        this.theBuffer = buffer;
        this.numBytes = numBytes;
        this.size = this.theBuffer.getInt();
        this.valuesOffset = this.theBuffer.position() + (this.size << 2);
        this.bufferBytes = 4 - numBytes;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public VSizeColumnarInts get(int index) {
        int endOffset;
        if (index >= this.size) {
            throw new IAE("Index[%d] >= size[%d]", new Object[]{index, this.size});
        }
        ByteBuffer myBuffer = this.theBuffer.asReadOnlyBuffer();
        int startOffset = 0;
        if (index == 0) {
            endOffset = myBuffer.getInt();
        } else {
            myBuffer.position(myBuffer.position() + (index - 1) * 4);
            startOffset = myBuffer.getInt();
            endOffset = myBuffer.getInt();
        }
        myBuffer.position(this.valuesOffset + startOffset);
        myBuffer.limit(myBuffer.position() + (endOffset - startOffset) + this.bufferBytes);
        return myBuffer.hasRemaining() ? new VSizeColumnarInts(myBuffer, this.numBytes) : null;
    }

    @Override
    public IndexedInts getUnshared(int index) {
        return this.get(index);
    }

    @Override
    public int indexOf(IndexedInts value) {
        throw new UnsupportedOperationException("Reverse lookup not allowed.");
    }

    @Override
    public long getSerializedSize() {
        return (long)META_SERDE_HELPER.size(this) + (long)this.theBuffer.remaining();
    }

    @Override
    public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        META_SERDE_HELPER.writeTo(channel, this);
        Channels.writeFully((WritableByteChannel)channel, (ByteBuffer)this.theBuffer.asReadOnlyBuffer());
    }

    public ColumnarMultiInts get() {
        return this;
    }

    public static VSizeColumnarMultiInts readFromByteBuffer(ByteBuffer buffer) {
        byte versionFromBuffer = buffer.get();
        if (1 == versionFromBuffer) {
            byte numBytes = buffer.get();
            int size = buffer.getInt();
            ByteBuffer bufferToUse = buffer.asReadOnlyBuffer();
            bufferToUse.limit(bufferToUse.position() + size);
            buffer.position(bufferToUse.limit());
            return new VSizeColumnarMultiInts(bufferToUse, numBytes);
        }
        throw new IAE("Unknown version[%s]", new Object[]{versionFromBuffer});
    }

    @Override
    public Iterator<IndexedInts> iterator() {
        return IndexedIterable.create(this).iterator();
    }

    @Override
    public void close() {
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("theBuffer", this.theBuffer);
    }
}

