/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.collections.spatial.search.Bound;
import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.query.filter.BitmapIndexSelector;
import org.apache.druid.query.filter.DruidDoublePredicate;
import org.apache.druid.query.filter.DruidFloatPredicate;
import org.apache.druid.query.filter.DruidLongPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.FilterTuning;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.segment.ColumnSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.incremental.SpatialDimensionRowTransformer;

public class SpatialFilter
implements Filter {
    private final String dimension;
    private final Bound bound;
    private final FilterTuning filterTuning;

    public SpatialFilter(String dimension, Bound bound, FilterTuning filterTuning) {
        this.dimension = (String)Preconditions.checkNotNull((Object)dimension, (Object)"dimension");
        this.bound = (Bound)Preconditions.checkNotNull((Object)bound, (Object)"bound");
        this.filterTuning = filterTuning;
    }

    @Override
    public <T> T getBitmapResult(BitmapIndexSelector selector, BitmapResultFactory<T> bitmapResultFactory) {
        Iterable<ImmutableBitmap> search = selector.getSpatialIndex(this.dimension).search(this.bound);
        return bitmapResultFactory.unionDimensionValueBitmaps(search);
    }

    @Override
    public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
        return Filters.makeValueMatcher(factory, this.dimension, new DruidPredicateFactory(){

            @Override
            public Predicate<String> makeStringPredicate() {
                return input -> {
                    if (input == null) {
                        return false;
                    }
                    float[] coordinate = SpatialDimensionRowTransformer.decode(input);
                    return SpatialFilter.this.bound.contains(coordinate);
                };
            }

            @Override
            public DruidLongPredicate makeLongPredicate() {
                return DruidLongPredicate.ALWAYS_FALSE;
            }

            @Override
            public DruidFloatPredicate makeFloatPredicate() {
                return DruidFloatPredicate.ALWAYS_FALSE;
            }

            @Override
            public DruidDoublePredicate makeDoublePredicate() {
                return DruidDoublePredicate.ALWAYS_FALSE;
            }
        });
    }

    @Override
    public boolean supportsBitmapIndex(BitmapIndexSelector selector) {
        return selector.getBitmapIndex(this.dimension) != null;
    }

    @Override
    public boolean shouldUseBitmapIndex(BitmapIndexSelector selector) {
        return Filters.shouldUseBitmapIndex(this, selector, this.filterTuning);
    }

    @Override
    public boolean supportsSelectivityEstimation(ColumnSelector columnSelector, BitmapIndexSelector indexSelector) {
        return false;
    }

    @Override
    public Set<String> getRequiredColumns() {
        return ImmutableSet.of((Object)this.dimension);
    }

    @Override
    public double estimateSelectivity(BitmapIndexSelector indexSelector) {
        throw new UnsupportedOperationException();
    }
}

