/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.transform;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputEntityReader;
import org.apache.druid.data.input.InputSourceReader;
import org.apache.druid.data.input.impl.InputRowParser;
import org.apache.druid.data.input.impl.StringInputRowParser;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.segment.transform.Transform;
import org.apache.druid.segment.transform.Transformer;
import org.apache.druid.segment.transform.TransformingInputEntityReader;
import org.apache.druid.segment.transform.TransformingInputRowParser;
import org.apache.druid.segment.transform.TransformingInputSourceReader;
import org.apache.druid.segment.transform.TransformingStringInputRowParser;

public class TransformSpec {
    public static final TransformSpec NONE = new TransformSpec(null, null);
    private final DimFilter filter;
    private final List<Transform> transforms;

    @JsonCreator
    public TransformSpec(@JsonProperty(value="filter") DimFilter filter, @JsonProperty(value="transforms") List<Transform> transforms) {
        this.filter = filter;
        this.transforms = transforms == null ? ImmutableList.of() : transforms;
        HashSet<String> seen = new HashSet<String>();
        for (Transform transform : this.transforms) {
            if (seen.add(transform.getName())) continue;
            throw new ISE("Transform name '%s' cannot be used twice", new Object[]{transform.getName()});
        }
    }

    public static <T> TransformSpec fromInputRowParser(InputRowParser<T> parser) {
        if (parser instanceof TransformingInputRowParser) {
            return ((TransformingInputRowParser)parser).getTransformSpec();
        }
        if (parser instanceof TransformingStringInputRowParser) {
            return ((TransformingStringInputRowParser)parser).getTransformSpec();
        }
        throw new ISE("Parser was not decorated, but should have been", new Object[0]);
    }

    @JsonProperty
    @Nullable
    public DimFilter getFilter() {
        return this.filter;
    }

    @JsonProperty
    public List<Transform> getTransforms() {
        return this.transforms;
    }

    public <T> InputRowParser<T> decorate(InputRowParser<T> parser) {
        if (parser instanceof StringInputRowParser) {
            return new TransformingStringInputRowParser(parser.getParseSpec(), ((StringInputRowParser)parser).getEncoding(), this);
        }
        return new TransformingInputRowParser<T>(parser, this);
    }

    public InputSourceReader decorate(InputSourceReader reader) {
        return new TransformingInputSourceReader(reader, this.toTransformer());
    }

    public InputEntityReader decorate(InputEntityReader reader) {
        return new TransformingInputEntityReader(reader, this.toTransformer());
    }

    public Transformer toTransformer() {
        return new Transformer(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransformSpec that = (TransformSpec)o;
        return Objects.equals(this.filter, that.filter) && Objects.equals(this.transforms, that.transforms);
    }

    public int hashCode() {
        return Objects.hash(this.filter, this.transforms);
    }

    public String toString() {
        return "TransformSpec{filter=" + this.filter + ", transforms=" + this.transforms + '}';
    }
}

