/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.vector;

import java.io.Closeable;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexStorageAdapter;
import org.apache.druid.segment.column.BaseColumn;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.DictionaryEncodedColumn;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.vector.MultiValueDimensionVectorSelector;
import org.apache.druid.segment.vector.NilVectorSelector;
import org.apache.druid.segment.vector.ReadableVectorOffset;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorValueSelector;

public class QueryableIndexVectorColumnSelectorFactory
implements VectorColumnSelectorFactory {
    private final QueryableIndex index;
    private final ReadableVectorOffset offset;
    private final Closer closer;
    private final Map<String, BaseColumn> columnCache;
    private final Map<DimensionSpec, SingleValueDimensionVectorSelector> singleValueDimensionSelectorCache;
    private final Map<DimensionSpec, MultiValueDimensionVectorSelector> multiValueDimensionSelectorCache;
    private final Map<String, VectorValueSelector> valueSelectorCache;
    private final Map<String, VectorObjectSelector> objectSelectorCache;

    public QueryableIndexVectorColumnSelectorFactory(QueryableIndex index, ReadableVectorOffset offset, Closer closer, Map<String, BaseColumn> columnCache) {
        this.index = index;
        this.offset = offset;
        this.closer = closer;
        this.columnCache = columnCache;
        this.singleValueDimensionSelectorCache = new HashMap<DimensionSpec, SingleValueDimensionVectorSelector>();
        this.multiValueDimensionSelectorCache = new HashMap<DimensionSpec, MultiValueDimensionVectorSelector>();
        this.valueSelectorCache = new HashMap<String, VectorValueSelector>();
        this.objectSelectorCache = new HashMap<String, VectorObjectSelector>();
    }

    @Override
    public int getMaxVectorSize() {
        return this.offset.getMaxVectorSize();
    }

    @Override
    public MultiValueDimensionVectorSelector makeMultiValueDimensionSelector(DimensionSpec dimensionSpec) {
        if (!dimensionSpec.canVectorize()) {
            throw new ISE("DimensionSpec[%s] cannot be vectorized", new Object[]{dimensionSpec});
        }
        return this.multiValueDimensionSelectorCache.computeIfAbsent(dimensionSpec, spec -> {
            ColumnHolder holder = this.index.getColumnHolder(spec.getDimension());
            if (holder == null || !holder.getCapabilities().isDictionaryEncoded() || holder.getCapabilities().getType() != ValueType.STRING || !holder.getCapabilities().hasMultipleValues()) {
                throw new ISE("Column[%s] is not a multi-value string column, do not ask for a multi-value selector", new Object[]{spec.getDimension()});
            }
            DictionaryEncodedColumn dictionaryEncodedColumn = (DictionaryEncodedColumn)this.getCachedColumn(spec.getDimension());
            MultiValueDimensionVectorSelector selector = dictionaryEncodedColumn.makeMultiValueDimensionVectorSelector(this.offset);
            return spec.decorate(selector);
        });
    }

    @Override
    public SingleValueDimensionVectorSelector makeSingleValueDimensionSelector(DimensionSpec dimensionSpec) {
        if (!dimensionSpec.canVectorize()) {
            throw new ISE("DimensionSpec[%s] cannot be vectorized", new Object[]{dimensionSpec});
        }
        return this.singleValueDimensionSelectorCache.computeIfAbsent(dimensionSpec, spec -> {
            ColumnHolder holder = this.index.getColumnHolder(spec.getDimension());
            if (holder == null || !holder.getCapabilities().isDictionaryEncoded() || holder.getCapabilities().getType() != ValueType.STRING) {
                return NilVectorSelector.create(this.offset);
            }
            if (holder.getCapabilities().hasMultipleValues()) {
                throw new ISE("Column[%s] is multi-value, do not ask for a single-value selector", new Object[]{spec.getDimension()});
            }
            DictionaryEncodedColumn dictionaryEncodedColumn = (DictionaryEncodedColumn)this.getCachedColumn(spec.getDimension());
            SingleValueDimensionVectorSelector selector = dictionaryEncodedColumn.makeSingleValueDimensionVectorSelector(this.offset);
            return spec.decorate(selector);
        });
    }

    @Override
    public VectorValueSelector makeValueSelector(String columnName) {
        return this.valueSelectorCache.computeIfAbsent(columnName, name -> {
            BaseColumn column = this.getCachedColumn((String)name);
            if (column == null) {
                return NilVectorSelector.create(this.offset);
            }
            return column.makeVectorValueSelector(this.offset);
        });
    }

    @Override
    public VectorObjectSelector makeObjectSelector(String columnName) {
        return this.objectSelectorCache.computeIfAbsent(columnName, name -> {
            BaseColumn column = this.getCachedColumn((String)name);
            if (column == null) {
                return NilVectorSelector.create(this.offset);
            }
            return column.makeVectorObjectSelector(this.offset);
        });
    }

    @Nullable
    private BaseColumn getCachedColumn(String columnName) {
        return this.columnCache.computeIfAbsent(columnName, name -> {
            ColumnHolder holder = this.index.getColumnHolder((String)name);
            if (holder != null) {
                return (BaseColumn)this.closer.register((Closeable)holder.getColumn());
            }
            return null;
        });
    }

    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String columnName) {
        return QueryableIndexStorageAdapter.getColumnCapabilities(this.index, columnName);
    }
}

