/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client;

import java.nio.ByteBuffer;
import org.apache.druid.client.cache.Cache;
import org.apache.druid.client.cache.CacheConfig;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.CacheStrategy;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryContexts;
import org.apache.druid.query.SegmentDescriptor;
import org.joda.time.Interval;

public class CacheUtil {
    public static Cache.NamedKey computeSegmentCacheKey(String segmentId, SegmentDescriptor descriptor, byte[] queryCacheKey) {
        Interval segmentQueryInterval = descriptor.getInterval();
        byte[] versionBytes = StringUtils.toUtf8((String)descriptor.getVersion());
        return new Cache.NamedKey(segmentId, ByteBuffer.allocate(16 + versionBytes.length + 4 + queryCacheKey.length).putLong(segmentQueryInterval.getStartMillis()).putLong(segmentQueryInterval.getEndMillis()).put(versionBytes).putInt(descriptor.getPartitionNumber()).put(queryCacheKey).array());
    }

    public static <T> boolean useCacheOnBrokers(Query<T> query, CacheStrategy<T, Object, Query<T>> strategy, CacheConfig cacheConfig) {
        return CacheUtil.useCache(query, strategy, cacheConfig) && strategy.isCacheable(query, false);
    }

    public static <T> boolean populateCacheOnBrokers(Query<T> query, CacheStrategy<T, Object, Query<T>> strategy, CacheConfig cacheConfig) {
        return CacheUtil.populateCache(query, strategy, cacheConfig) && strategy.isCacheable(query, false);
    }

    public static <T> boolean useCacheOnDataNodes(Query<T> query, CacheStrategy<T, Object, Query<T>> strategy, CacheConfig cacheConfig) {
        return CacheUtil.useCache(query, strategy, cacheConfig) && strategy.isCacheable(query, true);
    }

    public static <T> boolean populateCacheOnDataNodes(Query<T> query, CacheStrategy<T, Object, Query<T>> strategy, CacheConfig cacheConfig) {
        return CacheUtil.populateCache(query, strategy, cacheConfig) && strategy.isCacheable(query, true);
    }

    private static <T> boolean useCache(Query<T> query, CacheStrategy<T, Object, Query<T>> strategy, CacheConfig cacheConfig) {
        return QueryContexts.isUseCache(query) && strategy != null && cacheConfig.isUseCache() && cacheConfig.isQueryCacheable(query);
    }

    private static <T> boolean populateCache(Query<T> query, CacheStrategy<T, Object, Query<T>> strategy, CacheConfig cacheConfig) {
        return QueryContexts.isPopulateCache(query) && strategy != null && cacheConfig.isPopulateCache() && cacheConfig.isQueryCacheable(query);
    }
}

