/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client.indexing;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.client.indexing.IndexingWorker;
import org.joda.time.DateTime;

public class IndexingWorkerInfo {
    private final IndexingWorker worker;
    private final int currCapacityUsed;
    private final Set<String> availabilityGroups;
    private final Collection<String> runningTasks;
    private final DateTime lastCompletedTaskTime;
    private final DateTime blacklistedUntil;

    @JsonCreator
    public IndexingWorkerInfo(@JsonProperty(value="worker") IndexingWorker worker, @JsonProperty(value="currCapacityUsed") int currCapacityUsed, @JsonProperty(value="availabilityGroups") Set<String> availabilityGroups, @JsonProperty(value="runningTasks") Collection<String> runningTasks, @JsonProperty(value="lastCompletedTaskTime") DateTime lastCompletedTaskTime, @JsonProperty(value="blacklistedUntil") @Nullable DateTime blacklistedUntil) {
        this.worker = worker;
        this.currCapacityUsed = currCapacityUsed;
        this.availabilityGroups = availabilityGroups;
        this.runningTasks = runningTasks;
        this.lastCompletedTaskTime = lastCompletedTaskTime;
        this.blacklistedUntil = blacklistedUntil;
    }

    @JsonProperty(value="worker")
    public IndexingWorker getWorker() {
        return this.worker;
    }

    @JsonProperty(value="currCapacityUsed")
    public int getCurrCapacityUsed() {
        return this.currCapacityUsed;
    }

    @JsonProperty(value="availabilityGroups")
    public Set<String> getAvailabilityGroups() {
        return this.availabilityGroups;
    }

    public int getAvailableCapacity() {
        return this.getWorker().getCapacity() - this.getCurrCapacityUsed();
    }

    @JsonProperty(value="runningTasks")
    public Collection<String> getRunningTasks() {
        return this.runningTasks;
    }

    @JsonProperty(value="lastCompletedTaskTime")
    public DateTime getLastCompletedTaskTime() {
        return this.lastCompletedTaskTime;
    }

    @JsonProperty
    public DateTime getBlacklistedUntil() {
        return this.blacklistedUntil;
    }
}

