/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import com.google.inject.Inject;
import org.apache.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.druid.metadata.MetadataSegmentManager;
import org.apache.druid.metadata.MetadataSegmentManagerConfig;
import org.apache.druid.metadata.MetadataSegmentManagerProvider;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.druid.metadata.SQLMetadataSegmentManager;

public class SQLMetadataSegmentManagerProvider
implements MetadataSegmentManagerProvider {
    private final ObjectMapper jsonMapper;
    private final Supplier<MetadataSegmentManagerConfig> config;
    private final Supplier<MetadataStorageTablesConfig> storageConfig;
    private final SQLMetadataConnector connector;
    private final Lifecycle lifecycle;

    @Inject
    public SQLMetadataSegmentManagerProvider(ObjectMapper jsonMapper, Supplier<MetadataSegmentManagerConfig> config, Supplier<MetadataStorageTablesConfig> storageConfig, SQLMetadataConnector connector, Lifecycle lifecycle) {
        this.jsonMapper = jsonMapper;
        this.config = config;
        this.storageConfig = storageConfig;
        this.connector = connector;
        this.lifecycle = lifecycle;
    }

    @Override
    public MetadataSegmentManager get() {
        this.lifecycle.addHandler(new Lifecycle.Handler(){

            public void start() {
                SQLMetadataSegmentManagerProvider.this.connector.createSegmentTable();
            }

            public void stop() {
            }
        });
        return new SQLMetadataSegmentManager(this.jsonMapper, this.config, this.storageConfig, this.connector);
    }
}

