/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.server.coordination.DruidServerMetadata;
import org.joda.time.Interval;

public class LocatedSegmentDescriptor {
    private final Interval interval;
    private final String version;
    private final int partitionNumber;
    private final long size;
    private final List<DruidServerMetadata> locations;

    @JsonCreator
    public LocatedSegmentDescriptor(@JsonProperty(value="interval") Interval interval, @JsonProperty(value="version") String version, @JsonProperty(value="partitionNumber") int partitionNumber, @JsonProperty(value="size") long size, @JsonProperty(value="locations") List<DruidServerMetadata> locations) {
        this.interval = interval;
        this.version = version;
        this.partitionNumber = partitionNumber;
        this.size = size;
        this.locations = locations == null ? ImmutableList.of() : locations;
    }

    public LocatedSegmentDescriptor(SegmentDescriptor descriptor, long size, List<DruidServerMetadata> candidates) {
        this(descriptor.getInterval(), descriptor.getVersion(), descriptor.getPartitionNumber(), size, candidates);
    }

    @JsonProperty(value="interval")
    public Interval getInterval() {
        return this.interval;
    }

    @JsonProperty(value="version")
    public String getVersion() {
        return this.version;
    }

    @JsonProperty(value="partitionNumber")
    public int getPartitionNumber() {
        return this.partitionNumber;
    }

    @JsonProperty(value="size")
    public long getSize() {
        return this.size;
    }

    @JsonProperty(value="locations")
    public List<DruidServerMetadata> getLocations() {
        return this.locations;
    }

    public boolean equals(Object o) {
        if (!(o instanceof LocatedSegmentDescriptor)) {
            return false;
        }
        LocatedSegmentDescriptor other = (LocatedSegmentDescriptor)o;
        if (this.partitionNumber != other.partitionNumber) {
            return false;
        }
        if (!Objects.equals(this.interval, other.interval)) {
            return false;
        }
        return Objects.equals(this.version, other.version);
    }

    public int hashCode() {
        return Objects.hash(this.partitionNumber, this.interval, this.version);
    }

    public String toString() {
        return "LocatedSegmentDescriptor{interval=" + this.interval + ", version='" + this.version + '\'' + ", partitionNumber=" + this.partitionNumber + ", size=" + this.size + ", locations=" + this.locations + '}';
    }
}

