/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.loading;

import com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.druid.segment.loading.StorageLocation;
import org.apache.druid.segment.loading.StorageLocationSelectorStrategy;

public class LeastBytesUsedStorageLocationSelectorStrategy
implements StorageLocationSelectorStrategy {
    private static final Ordering<StorageLocation> ORDERING = Ordering.from(Comparator.comparingLong(StorageLocation::currSizeBytes));
    private List<StorageLocation> storageLocations;

    public LeastBytesUsedStorageLocationSelectorStrategy(List<StorageLocation> storageLocations) {
        this.storageLocations = storageLocations;
    }

    @Override
    public Iterator<StorageLocation> getLocations() {
        return ORDERING.sortedCopy(this.storageLocations).iterator();
    }

    public String toString() {
        return "LeastBytesUsedStorageLocationSelectorStrategy{storageLocations=" + this.storageLocations + '}';
    }
}

