/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime.appenderator;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.util.concurrent.ExecutorService;
import org.apache.druid.client.cache.Cache;
import org.apache.druid.client.cache.CacheConfig;
import org.apache.druid.client.cache.CachePopulatorStats;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.guice.annotations.Processing;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexMerger;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.indexing.RealtimeTuningConfig;
import org.apache.druid.segment.loading.DataSegmentPusher;
import org.apache.druid.segment.realtime.FireDepartmentMetrics;
import org.apache.druid.segment.realtime.appenderator.Appenderator;
import org.apache.druid.segment.realtime.appenderator.AppenderatorFactory;
import org.apache.druid.segment.realtime.appenderator.Appenderators;
import org.apache.druid.server.coordination.DataSegmentAnnouncer;
import org.apache.druid.timeline.partition.ShardSpec;

public class DefaultRealtimeAppenderatorFactory
implements AppenderatorFactory {
    private final ServiceEmitter emitter;
    private final QueryRunnerFactoryConglomerate conglomerate;
    private final DataSegmentAnnouncer segmentAnnouncer;
    private final ExecutorService queryExecutorService;
    private final DataSegmentPusher dataSegmentPusher;
    private final ObjectMapper jsonMapper;
    private final IndexIO indexIO;
    private final IndexMerger indexMerger;
    private final Cache cache;
    private final CacheConfig cacheConfig;
    private final CachePopulatorStats cachePopulatorStats;

    public DefaultRealtimeAppenderatorFactory(@JacksonInject ServiceEmitter emitter, @JacksonInject QueryRunnerFactoryConglomerate conglomerate, @JacksonInject DataSegmentAnnouncer segmentAnnouncer, @JacksonInject @Processing ExecutorService queryExecutorService, @JacksonInject DataSegmentPusher dataSegmentPusher, @JacksonInject @Json ObjectMapper jsonMapper, @JacksonInject IndexIO indexIO, @JacksonInject IndexMerger indexMerger, @JacksonInject Cache cache, @JacksonInject CacheConfig cacheConfig, @JacksonInject CachePopulatorStats cachePopulatorStats) {
        this.emitter = emitter;
        this.conglomerate = conglomerate;
        this.segmentAnnouncer = segmentAnnouncer;
        this.queryExecutorService = queryExecutorService;
        this.dataSegmentPusher = dataSegmentPusher;
        this.jsonMapper = jsonMapper;
        this.indexIO = indexIO;
        this.indexMerger = indexMerger;
        this.cache = cache;
        this.cacheConfig = cacheConfig;
        this.cachePopulatorStats = cachePopulatorStats;
    }

    @Override
    public Appenderator build(DataSchema schema, RealtimeTuningConfig config, FireDepartmentMetrics metrics) {
        return Appenderators.createRealtime(schema.getDataSource(), schema, config.withBasePersistDirectory(DefaultRealtimeAppenderatorFactory.makeBasePersistSubdirectory(config.getBasePersistDirectory(), schema.getDataSource(), config.getShardSpec())), metrics, this.dataSegmentPusher, this.jsonMapper, this.indexIO, this.indexMerger, this.conglomerate, this.segmentAnnouncer, this.emitter, this.queryExecutorService, this.cache, this.cacheConfig, this.cachePopulatorStats);
    }

    private static File makeBasePersistSubdirectory(File basePersistDirectory, String dataSource, ShardSpec shardSpec) {
        File dataSourceDirectory = new File(basePersistDirectory, dataSource);
        return new File(dataSourceDirectory, String.valueOf(shardSpec.getPartitionNum()));
    }
}

