/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime.appenderator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.indexing.overlord.SegmentPublishResult;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.OverwriteShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.Interval;

public interface TransactionalSegmentPublisher {
    public SegmentPublishResult publishAnnotatedSegments(@Nullable Set<DataSegment> var1, Set<DataSegment> var2, @Nullable Object var3) throws IOException;

    default public SegmentPublishResult publishSegments(@Nullable Set<DataSegment> segmentsToBeOverwritten, Set<DataSegment> segmentsToPublish, @Nullable Object commitMetadata) throws IOException {
        return this.publishAnnotatedSegments(segmentsToBeOverwritten, TransactionalSegmentPublisher.annotateAtomicUpdateGroupSize(segmentsToPublish), commitMetadata);
    }

    default public boolean supportsEmptyPublish() {
        return false;
    }

    public static Set<DataSegment> annotateAtomicUpdateGroupSize(Set<DataSegment> segments) {
        HashMap intervalToSegments = new HashMap();
        segments.forEach(segment -> intervalToSegments.computeIfAbsent(segment.getInterval(), k -> new ArrayList()).add(segment));
        for (Map.Entry entry : intervalToSegments.entrySet()) {
            Interval interval = (Interval)entry.getKey();
            List segmentsPerInterval = (List)entry.getValue();
            boolean isNonFirstGeneration = ((DataSegment)segmentsPerInterval.get(0)).getShardSpec() instanceof OverwriteShardSpec;
            boolean anyMismatch = segmentsPerInterval.stream().anyMatch(segment -> segment.getShardSpec() instanceof OverwriteShardSpec != isNonFirstGeneration);
            if (anyMismatch) {
                throw new ISE("WTH? some segments have empty overshadwedSegments but others are not? segments with non-overwritingShardSpec: [%s],segments with overwritingShardSpec: [%s]", new Object[]{segmentsPerInterval.stream().filter(segment -> !(segment.getShardSpec() instanceof OverwriteShardSpec)).collect(Collectors.toList()), segmentsPerInterval.stream().filter(segment -> segment.getShardSpec() instanceof OverwriteShardSpec).collect(Collectors.toList())});
            }
            if (!isNonFirstGeneration) continue;
            intervalToSegments.put(interval, segmentsPerInterval.stream().map(segment -> {
                OverwriteShardSpec shardSpec = (OverwriteShardSpec)segment.getShardSpec();
                return segment.withShardSpec((ShardSpec)shardSpec.withAtomicUpdateGroupSize((short)segmentsPerInterval.size()));
            }).collect(Collectors.toList()));
        }
        return intervalToSegments.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }
}

