/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.helper;

import org.apache.druid.client.DataSourcesSnapshot;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.server.coordinator.DruidCoordinator;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.helper.DruidCoordinatorHelper;
import org.apache.druid.timeline.DataSegment;

public class DruidCoordinatorSegmentInfoLoader
implements DruidCoordinatorHelper {
    private static final EmittingLogger log = new EmittingLogger(DruidCoordinatorSegmentInfoLoader.class);
    private final DruidCoordinator coordinator;

    public DruidCoordinatorSegmentInfoLoader(DruidCoordinator coordinator) {
        this.coordinator = coordinator;
    }

    @Override
    public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
        log.debug("Starting coordination. Getting used segments.", new Object[0]);
        DataSourcesSnapshot dataSourcesSnapshot = params.getDataSourcesSnapshot();
        for (DataSegment segment : dataSourcesSnapshot.iterateAllUsedSegmentsInSnapshot()) {
            if (segment.getSize() >= 0L) continue;
            log.makeAlert("No size on a segment", new Object[0]).addData("segment", (Object)segment).emit();
        }
        if (log.isDebugEnabled()) {
            log.debug("Used Segments", new Object[0]);
            for (DataSegment dataSegment : dataSourcesSnapshot.iterateAllUsedSegmentsInSnapshot()) {
                log.debug("  %s", new Object[]{dataSegment});
            }
        }
        log.info("Found [%,d] used segments.", new Object[]{params.getUsedSegments().size()});
        return params;
    }
}

