/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.metrics;

import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.druid.guice.DruidBinders;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.JvmCpuMonitor;
import org.apache.druid.java.util.metrics.JvmMonitor;
import org.apache.druid.java.util.metrics.JvmThreadsMonitor;
import org.apache.druid.java.util.metrics.Monitor;
import org.apache.druid.java.util.metrics.MonitorScheduler;
import org.apache.druid.java.util.metrics.MonitorSchedulerConfig;
import org.apache.druid.java.util.metrics.SysMonitor;
import org.apache.druid.query.ExecutorServiceMonitor;
import org.apache.druid.server.metrics.DataSourceTaskIdHolder;
import org.apache.druid.server.metrics.DruidMonitorSchedulerConfig;
import org.apache.druid.server.metrics.EventReceiverFirehoseRegister;
import org.apache.druid.server.metrics.MonitorsConfig;

public class MetricsModule
implements Module {
    private static final Logger log = new Logger(MetricsModule.class);

    public static void register(Binder binder, Class<? extends Monitor> monitorClazz) {
        DruidBinders.metricMonitorBinder(binder).addBinding().toInstance(monitorClazz);
    }

    public void configure(Binder binder) {
        JsonConfigProvider.bind((Binder)binder, (String)"druid.monitoring", DruidMonitorSchedulerConfig.class);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.monitoring", MonitorsConfig.class);
        DruidBinders.metricMonitorBinder(binder);
        binder.bind(DataSourceTaskIdHolder.class).in(LazySingleton.class);
        binder.bind(EventReceiverFirehoseRegister.class).in(LazySingleton.class);
        binder.bind(ExecutorServiceMonitor.class).in(LazySingleton.class);
        binder.bind(Key.get(MonitorScheduler.class, (Annotation)Names.named((String)"ForTheEagerness"))).to(MonitorScheduler.class).asEagerSingleton();
    }

    @Provides
    @ManageLifecycle
    public MonitorScheduler getMonitorScheduler(Supplier<DruidMonitorSchedulerConfig> config, MonitorsConfig monitorsConfig, Set<Class<? extends Monitor>> monitorSet, ServiceEmitter emitter, Injector injector) {
        ArrayList<Object> monitors = new ArrayList<Object>();
        for (Class monitorClass : Iterables.concat(monitorsConfig.getMonitors(), monitorSet)) {
            monitors.add(injector.getInstance(monitorClass));
        }
        if (!monitors.isEmpty()) {
            log.info("Loaded %d monitors: %s", new Object[]{monitors.size(), monitors.stream().map(monitor -> monitor.getClass().getName()).collect(Collectors.joining(", "))});
        }
        return new MonitorScheduler((MonitorSchedulerConfig)config.get(), Execs.scheduledSingleThreaded((String)"MonitorScheduler-%s"), emitter, monitors);
    }

    @Provides
    @ManageLifecycle
    public JvmMonitor getJvmMonitor(DataSourceTaskIdHolder dataSourceTaskIdHolder) {
        Map<String, String[]> dimensions = MonitorsConfig.mapOfDatasourceAndTaskID(dataSourceTaskIdHolder.getDataSource(), dataSourceTaskIdHolder.getTaskId());
        return new JvmMonitor(dimensions);
    }

    @Provides
    @ManageLifecycle
    public JvmCpuMonitor getJvmCpuMonitor(DataSourceTaskIdHolder dataSourceTaskIdHolder) {
        Map<String, String[]> dimensions = MonitorsConfig.mapOfDatasourceAndTaskID(dataSourceTaskIdHolder.getDataSource(), dataSourceTaskIdHolder.getTaskId());
        return new JvmCpuMonitor(dimensions);
    }

    @Provides
    @ManageLifecycle
    public JvmThreadsMonitor getJvmThreadsMonitor(DataSourceTaskIdHolder dataSourceTaskIdHolder) {
        Map<String, String[]> dimensions = MonitorsConfig.mapOfDatasourceAndTaskID(dataSourceTaskIdHolder.getDataSource(), dataSourceTaskIdHolder.getTaskId());
        return new JvmThreadsMonitor(dimensions);
    }

    @Provides
    @ManageLifecycle
    public SysMonitor getSysMonitor(DataSourceTaskIdHolder dataSourceTaskIdHolder) {
        Map<String, String[]> dimensions = MonitorsConfig.mapOfDatasourceAndTaskID(dataSourceTaskIdHolder.getDataSource(), dataSourceTaskIdHolder.getTaskId());
        return new SysMonitor(dimensions);
    }
}

