/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.security;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Map;
import javax.annotation.Nullable;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.Authenticator;

@JsonTypeName(value="trustedDomain")
public class TrustedDomainAuthenticator
implements Authenticator {
    private static final Logger LOGGER = new Logger(TrustedDomainAuthenticator.class);
    private static final String DEFAULT_IDENTITY = "defaultUser";
    private static final String X_FORWARDED_FOR = "X-Forwarded-For";
    private static final boolean DEFAULT_USE_FORWARDED_HEADERS = false;
    private final AuthenticationResult authenticationResult;
    private final String domain;
    private final boolean useForwardedHeaders;

    @JsonCreator
    public TrustedDomainAuthenticator(@JsonProperty(value="name") String name, @JsonProperty(value="domain") String domain, @JsonProperty(value="useForwardedHeaders") Boolean useForwardedHeaders, @JsonProperty(value="authorizerName") String authorizerName, @JsonProperty(value="identity") String identity) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)domain) ? 1 : 0) != 0, (String)"Invalid domain name %s", (Object[])new Object[]{domain});
        this.domain = domain;
        this.useForwardedHeaders = useForwardedHeaders == null ? false : useForwardedHeaders;
        this.authenticationResult = new AuthenticationResult(identity == null ? DEFAULT_IDENTITY : identity, authorizerName, name, null);
    }

    @Override
    public Class<? extends Filter> getFilterClass() {
        return null;
    }

    @Override
    public Map<String, String> getInitParameters() {
        return null;
    }

    @Override
    public String getPath() {
        return "/*";
    }

    @Override
    public EnumSet<DispatcherType> getDispatcherType() {
        return null;
    }

    @Override
    public Filter getFilter() {
        return new Filter(){

            public void init(FilterConfig filterConfig) {
            }

            public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
                String forwarded_for;
                String remoteAddr = request.getRemoteAddr();
                LOGGER.debug("Client IP Address: %s", new Object[]{remoteAddr});
                if (TrustedDomainAuthenticator.this.useForwardedHeaders && (forwarded_for = TrustedDomainAuthenticator.getForwardedAddress(request)) != null) {
                    LOGGER.debug("Forwarded IP Address: %s", new Object[]{remoteAddr});
                    remoteAddr = forwarded_for;
                }
                if (remoteAddr.endsWith(TrustedDomainAuthenticator.this.domain)) {
                    request.setAttribute("Druid-Authentication-Result", (Object)TrustedDomainAuthenticator.this.authenticationResult);
                }
                chain.doFilter(request, response);
            }

            public void destroy() {
            }
        };
    }

    @Nullable
    private static String getForwardedAddress(ServletRequest request) {
        String forwarded_for;
        if (request instanceof HttpServletRequest && !Strings.isNullOrEmpty((String)(forwarded_for = ((HttpServletRequest)request).getHeader(X_FORWARDED_FOR)))) {
            return forwarded_for.split(",")[0];
        }
        return null;
    }

    @Override
    @Nullable
    public String getAuthChallengeHeader() {
        return null;
    }

    @Override
    @Nullable
    public AuthenticationResult authenticateJDBCContext(Map<String, Object> context) {
        return null;
    }
}

