/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.aggregation;

import java.util.Objects;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.sql.calcite.expression.DruidExpression;

public class DimensionExpression {
    private final String outputName;
    private final DruidExpression expression;
    private final ValueType outputType;

    public DimensionExpression(String outputName, DruidExpression expression, ValueType outputType) {
        this.outputName = outputName;
        this.expression = expression;
        this.outputType = outputType;
    }

    public String getOutputName() {
        return this.outputName;
    }

    public DruidExpression getDruidExpression() {
        return this.expression;
    }

    public DimensionSpec toDimensionSpec() {
        if (this.expression.isSimpleExtraction()) {
            return this.expression.getSimpleExtraction().toDimensionSpec(this.outputName, this.outputType);
        }
        return new DefaultDimensionSpec(this.getOutputName(), this.getOutputName(), this.outputType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DimensionExpression that = (DimensionExpression)o;
        return Objects.equals(this.outputName, that.outputName) && Objects.equals(this.expression, that.expression) && this.outputType == that.outputType;
    }

    public int hashCode() {
        return Objects.hash(this.outputName, this.expression, this.outputType);
    }

    public String toString() {
        return "DimensionExpression{outputName='" + this.outputName + '\'' + ", expression=" + this.expression + ", outputType=" + this.outputType + '}';
    }
}

