/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.aggregation.builtin;

import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.DoubleMaxAggregatorFactory;
import org.apache.druid.query.aggregation.FloatMaxAggregatorFactory;
import org.apache.druid.query.aggregation.LongMaxAggregatorFactory;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.sql.calcite.aggregation.Aggregation;
import org.apache.druid.sql.calcite.aggregation.builtin.SimpleSqlAggregator;
import org.apache.druid.sql.calcite.planner.Calcites;

public class MaxSqlAggregator
extends SimpleSqlAggregator {
    @Override
    public SqlAggFunction calciteFunction() {
        return SqlStdOperatorTable.MAX;
    }

    @Override
    Aggregation getAggregation(String name, AggregateCall aggregateCall, ExprMacroTable macroTable, String fieldName, String expression) {
        ValueType valueType = Calcites.getValueTypeForSqlTypeName(aggregateCall.getType().getSqlTypeName());
        return Aggregation.create(MaxSqlAggregator.createMaxAggregatorFactory(valueType, name, fieldName, expression, macroTable));
    }

    private static AggregatorFactory createMaxAggregatorFactory(ValueType aggregationType, String name, String fieldName, String expression, ExprMacroTable macroTable) {
        switch (aggregationType) {
            case LONG: {
                return new LongMaxAggregatorFactory(name, fieldName, expression, macroTable);
            }
            case FLOAT: {
                return new FloatMaxAggregatorFactory(name, fieldName, expression, macroTable);
            }
            case DOUBLE: {
                return new DoubleMaxAggregatorFactory(name, fieldName, expression, macroTable);
            }
        }
        throw new ISE("Cannot create aggregator factory for type[%s]", new Object[]{aggregationType});
    }
}

