/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.aggregation.builtin;

import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.aggregation.FloatSumAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.sql.calcite.aggregation.Aggregation;
import org.apache.druid.sql.calcite.aggregation.builtin.SimpleSqlAggregator;
import org.apache.druid.sql.calcite.planner.Calcites;

public class SumSqlAggregator
extends SimpleSqlAggregator {
    @Override
    public SqlAggFunction calciteFunction() {
        return SqlStdOperatorTable.SUM;
    }

    @Override
    Aggregation getAggregation(String name, AggregateCall aggregateCall, ExprMacroTable macroTable, String fieldName, String expression) {
        ValueType valueType = Calcites.getValueTypeForSqlTypeName(aggregateCall.getType().getSqlTypeName());
        return Aggregation.create(SumSqlAggregator.createSumAggregatorFactory(valueType, name, fieldName, expression, macroTable));
    }

    static AggregatorFactory createSumAggregatorFactory(ValueType aggregationType, String name, String fieldName, String expression, ExprMacroTable macroTable) {
        switch (aggregationType) {
            case LONG: {
                return new LongSumAggregatorFactory(name, fieldName, expression, macroTable);
            }
            case FLOAT: {
                return new FloatSumAggregatorFactory(name, fieldName, expression, macroTable);
            }
            case DOUBLE: {
                return new DoubleSumAggregatorFactory(name, fieldName, expression, macroTable);
            }
        }
        throw new ISE("Cannot create aggregator factory for type[%s]", new Object[]{aggregationType});
    }
}

