/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression.builtin;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.OperatorConversions;
import org.apache.druid.sql.calcite.expression.SqlOperatorConversion;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.table.RowSignature;

public class PositionOperatorConversion
implements SqlOperatorConversion {
    private static final DruidExpression ZERO = DruidExpression.fromExpression("0");

    @Override
    public SqlOperator calciteOperator() {
        return SqlStdOperatorTable.POSITION;
    }

    @Override
    public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
        return OperatorConversions.convertCall(plannerContext, rowSignature, rexNode, druidExpressions -> {
            DruidExpression fromIndexExpression = druidExpressions.size() > 2 ? DruidExpression.fromExpression(StringUtils.format((String)"(%s - 1)", (Object[])new Object[]{((DruidExpression)druidExpressions.get(2)).getExpression()})) : ZERO;
            return DruidExpression.fromExpression(StringUtils.format((String)"(%s + 1)", (Object[])new Object[]{DruidExpression.functionCall("strpos", (List<DruidExpression>)ImmutableList.of(druidExpressions.get(1), druidExpressions.get(0), (Object)fromIndexExpression))}));
        });
    }
}

