/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression.builtin;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.OperatorConversions;
import org.apache.druid.sql.calcite.expression.SqlOperatorConversion;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.table.RowSignature;

public class StringFormatOperatorConversion
implements SqlOperatorConversion {
    private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder("STRING_FORMAT").operandTypeChecker(new StringFormatOperandTypeChecker()).functionCategory(SqlFunctionCategory.STRING).returnType(SqlTypeName.VARCHAR).build();

    @Override
    public SqlOperator calciteOperator() {
        return SQL_FUNCTION;
    }

    @Override
    public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
        return OperatorConversions.convertCall(plannerContext, rowSignature, rexNode, "format");
    }

    private static class StringFormatOperandTypeChecker
    implements SqlOperandTypeChecker {
        private StringFormatOperandTypeChecker() {
        }

        public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
            RelDataType firstArgType = callBinding.getOperandType(0);
            if (SqlTypeName.CHAR_TYPES.contains(firstArgType.getSqlTypeName())) {
                return true;
            }
            if (throwOnFailure) {
                throw callBinding.newValidationSignatureError();
            }
            return false;
        }

        public SqlOperandCountRange getOperandCountRange() {
            return SqlOperandCountRanges.from((int)1);
        }

        public String getAllowedSignatures(SqlOperator op, String opName) {
            return StringUtils.format((String)"%s(CHARACTER, [ANY, ...])", (Object[])new Object[]{opName});
        }

        public SqlOperandTypeChecker.Consistency getConsistency() {
            return SqlOperandTypeChecker.Consistency.NONE;
        }

        public boolean isOptional(int i) {
            return i > 0;
        }
    }
}

