/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression.builtin;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.expression.SqlOperatorConversion;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.table.RowSignature;

public abstract class TimeArithmeticOperatorConversion
implements SqlOperatorConversion {
    private final SqlOperator operator;
    private final int direction;

    public TimeArithmeticOperatorConversion(SqlOperator operator, int direction) {
        this.operator = operator;
        this.direction = direction;
        Preconditions.checkArgument((direction > 0 || direction < 0 ? 1 : 0) != 0);
    }

    @Override
    public SqlOperator calciteOperator() {
        return this.operator;
    }

    @Override
    public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
        RexCall call = (RexCall)rexNode;
        List operands = call.getOperands();
        if (operands.size() != 2) {
            throw new IAE("Expected 2 args, got %s", new Object[]{operands.size()});
        }
        RexNode leftRexNode = (RexNode)operands.get(0);
        RexNode rightRexNode = (RexNode)operands.get(1);
        DruidExpression leftExpr = Expressions.toDruidExpression(plannerContext, rowSignature, leftRexNode);
        DruidExpression rightExpr = Expressions.toDruidExpression(plannerContext, rowSignature, rightRexNode);
        if (leftExpr == null || rightExpr == null) {
            return null;
        }
        if (rightRexNode.getType().getFamily() == SqlTypeFamily.INTERVAL_YEAR_MONTH) {
            return DruidExpression.fromExpression(DruidExpression.functionCall("timestamp_shift", leftExpr, rightExpr.map(simpleExtraction -> null, expression -> StringUtils.format((String)"concat('P', %s, 'M')", (Object[])new Object[]{expression})), DruidExpression.fromExpression(DruidExpression.numberLiteral(this.direction > 0 ? 1 : -1)), DruidExpression.fromExpression(DruidExpression.stringLiteral(plannerContext.getTimeZone().getID()))));
        }
        if (rightRexNode.getType().getFamily() == SqlTypeFamily.INTERVAL_DAY_TIME) {
            return DruidExpression.fromExpression(StringUtils.format((String)"(%s %s %s)", (Object[])new Object[]{leftExpr.getExpression(), this.direction > 0 ? "+" : "-", rightExpr.getExpression()}));
        }
        if (!(leftRexNode.getType().getFamily() != SqlTypeFamily.TIMESTAMP && leftRexNode.getType().getFamily() != SqlTypeFamily.DATE || rightRexNode.getType().getFamily() != SqlTypeFamily.TIMESTAMP && rightRexNode.getType().getFamily() != SqlTypeFamily.DATE)) {
            Preconditions.checkState((this.direction < 0 ? 1 : 0) != 0, (Object)"Time arithmetic require direction < 0");
            if (call.getType().getFamily() == SqlTypeFamily.INTERVAL_YEAR_MONTH) {
                return DruidExpression.fromExpression(DruidExpression.functionCall("subtract_months", leftExpr, rightExpr, DruidExpression.fromExpression(DruidExpression.stringLiteral(plannerContext.getTimeZone().getID()))));
            }
            return DruidExpression.fromExpression(StringUtils.format((String)"(%s %s %s)", (Object[])new Object[]{leftExpr.getExpression(), "-", rightExpr.getExpression()}));
        }
        throw new ISE("Got unexpected type period type family[%s]", new Object[]{rightRexNode.getType().getFamily()});
    }

    public static class TimeMinusIntervalOperatorConversion
    extends TimeArithmeticOperatorConversion {
        public TimeMinusIntervalOperatorConversion() {
            super((SqlOperator)SqlStdOperatorTable.MINUS_DATE, -1);
        }
    }

    public static class TimePlusIntervalOperatorConversion
    extends TimeArithmeticOperatorConversion {
        public TimePlusIntervalOperatorConversion() {
            super((SqlOperator)SqlStdOperatorTable.DATETIME_PLUS, 1);
        }
    }
}

