/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.interpreter.BindableConvention;
import org.apache.calcite.interpreter.BindableRel;
import org.apache.calcite.interpreter.Bindables;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.logical.LogicalSort;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlExplain;
import org.apache.calcite.sql.SqlExplainFormat;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.type.BasicSqlType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.tools.Planner;
import org.apache.calcite.tools.RelConversionException;
import org.apache.calcite.tools.ValidationException;
import org.apache.calcite.util.Pair;
import org.apache.druid.java.util.common.guava.BaseSequence;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.DruidTypeSystem;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.planner.PlannerResult;
import org.apache.druid.sql.calcite.rel.DruidConvention;
import org.apache.druid.sql.calcite.rel.DruidRel;

public class DruidPlanner
implements Closeable {
    private final Planner planner;
    private final PlannerContext plannerContext;
    private RexBuilder rexBuilder;

    public DruidPlanner(Planner planner, PlannerContext plannerContext) {
        this.planner = planner;
        this.plannerContext = plannerContext;
    }

    public PlannerResult plan(String sql) throws SqlParseException, ValidationException, RelConversionException {
        SqlExplain explain = null;
        SqlNode parsed = this.planner.parse(sql);
        if (parsed.getKind() == SqlKind.EXPLAIN) {
            explain = (SqlExplain)parsed;
            parsed = explain.getExplicandum();
        }
        this.rexBuilder = new RexBuilder(this.planner.getTypeFactory());
        SqlNode validated = this.planner.validate(parsed);
        RelRoot root = this.planner.rel(validated);
        try {
            return this.planWithDruidConvention(explain, root);
        }
        catch (RelOptPlanner.CannotPlanException e) {
            try {
                return this.planWithBindableConvention(explain, root);
            }
            catch (Exception e2) {
                e.addSuppressed((Throwable)e2);
                throw e;
            }
        }
    }

    public PlannerContext getPlannerContext() {
        return this.plannerContext;
    }

    @Override
    public void close() {
        this.planner.close();
    }

    private PlannerResult planWithDruidConvention(SqlExplain explain, RelRoot root) throws RelConversionException {
        RelNode possiblyWrappedRootRel = this.possiblyWrapRootWithOuterLimitFromContext(root);
        DruidRel druidRel = (DruidRel)this.planner.transform(0, this.planner.getEmptyTraitSet().replace((RelTrait)DruidConvention.instance()).plus((RelTrait)root.collation), possiblyWrappedRootRel);
        ImmutableSet dataSourceNames = ImmutableSet.copyOf(druidRel.getDataSourceNames());
        if (explain != null) {
            return this.planExplanation((RelNode)druidRel, explain, (Set<String>)dataSourceNames);
        }
        Supplier resultsSupplier = () -> {
            if (root.isRefTrivial()) {
                return druidRel.runQuery();
            }
            return Sequences.map(druidRel.runQuery(), input -> {
                Object[] retVal = new Object[root.fields.size()];
                for (int i = 0; i < root.fields.size(); ++i) {
                    retVal[i] = input[(Integer)((Pair)root.fields.get(i)).getKey()];
                }
                return retVal;
            });
        };
        return new PlannerResult((Supplier<Sequence<Object[]>>)resultsSupplier, root.validatedRowType, (Set<String>)dataSourceNames);
    }

    private PlannerResult planWithBindableConvention(SqlExplain explain, RelRoot root) throws RelConversionException {
        BindableRel bindableRel = (BindableRel)this.planner.transform(1, this.planner.getEmptyTraitSet().replace((RelTrait)BindableConvention.INSTANCE).plus((RelTrait)root.collation), root.rel);
        if (!root.isRefTrivial()) {
            ArrayList<RexInputRef> projects = new ArrayList<RexInputRef>();
            RexBuilder rexBuilder = bindableRel.getCluster().getRexBuilder();
            Iterator iterator = Pair.left((List)root.fields).iterator();
            while (iterator.hasNext()) {
                int field = (Integer)iterator.next();
                projects.add(rexBuilder.makeInputRef((RelNode)bindableRel, field));
            }
            bindableRel = new Bindables.BindableProject(bindableRel.getCluster(), bindableRel.getTraitSet(), (RelNode)bindableRel, projects, root.validatedRowType);
        }
        if (explain != null) {
            return this.planExplanation((RelNode)bindableRel, explain, (Set<String>)ImmutableSet.of());
        }
        BindableRel theRel = bindableRel;
        DataContext dataContext = this.plannerContext.createDataContext((JavaTypeFactory)this.planner.getTypeFactory());
        Supplier resultsSupplier = () -> {
            Enumerable enumerable = theRel.bind(dataContext);
            final Enumerator enumerator = enumerable.enumerator();
            return Sequences.withBaggage((Sequence)new BaseSequence((BaseSequence.IteratorMaker)new BaseSequence.IteratorMaker<Object[], EnumeratorIterator<Object[]>>(){

                public EnumeratorIterator<Object[]> make() {
                    return new EnumeratorIterator<Object[]>(new Iterator<Object[]>(){

                        @Override
                        public boolean hasNext() {
                            return enumerator.moveNext();
                        }

                        @Override
                        public Object[] next() {
                            return (Object[])enumerator.current();
                        }
                    });
                }

                public void cleanup(EnumeratorIterator iterFromMake) {
                }
            }), () -> ((Enumerator)enumerator).close());
        };
        return new PlannerResult((Supplier<Sequence<Object[]>>)resultsSupplier, root.validatedRowType, (Set<String>)ImmutableSet.of());
    }

    @Nullable
    private RelNode possiblyWrapRootWithOuterLimitFromContext(RelRoot root) {
        Object outerLimitObj = this.plannerContext.getQueryContext().get("sqlOuterLimit");
        Long outerLimit = DimensionHandlerUtils.convertObjectToLong((Object)outerLimitObj, (boolean)true);
        if (outerLimit == null) {
            return root.rel;
        }
        if (root.rel instanceof Sort) {
            Sort innerSort = (Sort)root.rel;
            int offset = Calcites.getOffset(innerSort);
            int innerLimit = Calcites.getFetch(innerSort);
            int fetch = Calcites.collapseFetch(innerLimit, Ints.checkedCast((long)outerLimit), 0);
            if (fetch == innerLimit) {
                return root.rel;
            }
            return LogicalSort.create((RelNode)innerSort.getInput(), (RelCollation)innerSort.collation, (RexNode)(offset > 0 ? this.makeBigIntLiteral(offset) : null), (RexNode)this.makeBigIntLiteral(fetch));
        }
        return LogicalSort.create((RelNode)root.rel, (RelCollation)root.collation, null, (RexNode)this.makeBigIntLiteral(outerLimit));
    }

    private RexNode makeBigIntLiteral(long value) {
        return this.rexBuilder.makeLiteral((Object)value, (RelDataType)new BasicSqlType((RelDataTypeSystem)DruidTypeSystem.INSTANCE, SqlTypeName.BIGINT), false);
    }

    private PlannerResult planExplanation(RelNode rel, SqlExplain explain, Set<String> datasourceNames) {
        String explanation = RelOptUtil.dumpPlan((String)"", (RelNode)rel, (SqlExplainFormat)explain.getFormat(), (SqlExplainLevel)explain.getDetailLevel());
        Supplier resultsSupplier = Suppliers.ofInstance((Object)Sequences.simple((Iterable)ImmutableList.of((Object)new Object[]{explanation})));
        RelDataTypeFactory typeFactory = rel.getCluster().getTypeFactory();
        return new PlannerResult((Supplier<Sequence<Object[]>>)resultsSupplier, typeFactory.createStructType((List)ImmutableList.of((Object)Calcites.createSqlType(typeFactory, SqlTypeName.VARCHAR)), (List)ImmutableList.of((Object)"PLAN")), datasourceNames);
    }

    private static class EnumeratorIterator<T>
    implements Iterator<T> {
        private final Iterator<T> it;

        EnumeratorIterator(Iterator<T> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public T next() {
            return this.it.next();
        }
    }
}

