/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rel;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.sql.calcite.rel.DruidConvention;
import org.apache.druid.sql.calcite.rel.DruidQuery;
import org.apache.druid.sql.calcite.rel.DruidRel;
import org.apache.druid.sql.calcite.rel.PartialDruidQuery;
import org.apache.druid.sql.calcite.rel.QueryMaker;
import org.apache.druid.sql.calcite.table.DruidTable;

public class DruidQueryRel
extends DruidRel<DruidQueryRel> {
    private static final double COST_BASE = 1.0;
    private static final double COST_PER_COLUMN = 0.001;
    private static final double COST_FILTER_MULTIPLIER = 0.1;
    private static final double COST_GROUPING_MULTIPLIER = 0.5;
    private static final double COST_LIMIT_MULTIPLIER = 0.5;
    private static final double COST_HAVING_MULTIPLIER = 5.0;
    private final RelOptTable table;
    private final DruidTable druidTable;
    private final PartialDruidQuery partialQuery;

    private DruidQueryRel(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, DruidTable druidTable, QueryMaker queryMaker, PartialDruidQuery partialQuery) {
        super(cluster, traitSet, queryMaker);
        this.table = (RelOptTable)Preconditions.checkNotNull((Object)table, (Object)"table");
        this.druidTable = (DruidTable)Preconditions.checkNotNull((Object)druidTable, (Object)"druidTable");
        this.partialQuery = (PartialDruidQuery)Preconditions.checkNotNull((Object)partialQuery, (Object)"partialQuery");
    }

    public static DruidQueryRel fullScan(LogicalTableScan scanRel, RelOptTable table, DruidTable druidTable, QueryMaker queryMaker) {
        return new DruidQueryRel(scanRel.getCluster(), scanRel.getCluster().traitSetOf((RelTrait)Convention.NONE), table, druidTable, queryMaker, PartialDruidQuery.create((RelNode)scanRel));
    }

    @Override
    @Nonnull
    public DruidQuery toDruidQuery(boolean finalizeAggregations) {
        return this.partialQuery.build(this.druidTable.getDataSource(), this.druidTable.getRowSignature(), this.getPlannerContext(), this.getCluster().getRexBuilder(), finalizeAggregations);
    }

    @Override
    public DruidQuery toDruidQueryForExplaining() {
        return this.toDruidQuery(false);
    }

    @Override
    public DruidQueryRel asDruidConvention() {
        return new DruidQueryRel(this.getCluster(), this.getTraitSet().replace((RelTrait)DruidConvention.instance()), this.table, this.druidTable, this.getQueryMaker(), this.partialQuery);
    }

    @Override
    public List<String> getDataSourceNames() {
        return this.druidTable.getDataSource().getNames();
    }

    @Override
    public PartialDruidQuery getPartialDruidQuery() {
        return this.partialQuery;
    }

    @Override
    public DruidQueryRel withPartialQuery(PartialDruidQuery newQueryBuilder) {
        return new DruidQueryRel(this.getCluster(), this.getTraitSet().plusAll(newQueryBuilder.getRelTraits()), this.table, this.druidTable, this.getQueryMaker(), newQueryBuilder);
    }

    @Override
    public int getQueryCount() {
        return 1;
    }

    @Override
    public Sequence<Object[]> runQuery() {
        return this.getQueryMaker().runQuery(this.toDruidQuery(false));
    }

    public RelOptTable getTable() {
        return this.table;
    }

    protected RelDataType deriveRowType() {
        return this.partialQuery.getRowType();
    }

    public RelWriter explainTerms(RelWriter pw) {
        String queryString;
        DruidQuery druidQuery = this.toDruidQueryForExplaining();
        try {
            queryString = this.getQueryMaker().getJsonMapper().writeValueAsString((Object)druidQuery.getQuery());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return pw.item("query", (Object)queryString).item("signature", (Object)druidQuery.getOutputRowSignature());
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double cost = 1.0;
        if (this.partialQuery.getSelectProject() != null) {
            cost += 0.001 * (double)this.partialQuery.getSelectProject().getChildExps().size();
        }
        if (this.partialQuery.getWhereFilter() != null) {
            cost *= 0.1;
        }
        if (this.partialQuery.getAggregate() != null) {
            cost *= 0.5;
            cost += 0.001 * (double)this.partialQuery.getAggregate().getGroupSet().size();
            cost += 0.001 * (double)this.partialQuery.getAggregate().getAggCallList().size();
        }
        if (this.partialQuery.getAggregateProject() != null) {
            cost += 0.001 * (double)this.partialQuery.getAggregateProject().getChildExps().size();
        }
        if (this.partialQuery.getSort() != null && this.partialQuery.getSort().fetch != null) {
            cost *= 0.5;
        }
        if (this.partialQuery.getSortProject() != null) {
            cost += 0.001 * (double)this.partialQuery.getSortProject().getChildExps().size();
        }
        if (this.partialQuery.getHavingFilter() != null) {
            cost *= 5.0;
        }
        return planner.getCostFactory().makeCost(cost, 0.0, 0.0);
    }
}

