/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rel;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.table.RowSignature;

public class VirtualColumnRegistry {
    private final RowSignature baseRowSignature;
    private final Map<String, VirtualColumn> virtualColumnsByExpression;
    private final Map<String, VirtualColumn> virtualColumnsByName;
    private final String virtualColumnPrefix;
    private int virtualColumnCounter;

    private VirtualColumnRegistry(RowSignature baseRowSignature, String virtualColumnPrefix, Map<String, VirtualColumn> virtualColumnsByExpression, Map<String, VirtualColumn> virtualColumnsByName) {
        this.baseRowSignature = baseRowSignature;
        this.virtualColumnPrefix = virtualColumnPrefix;
        this.virtualColumnsByExpression = virtualColumnsByExpression;
        this.virtualColumnsByName = virtualColumnsByName;
    }

    public static VirtualColumnRegistry create(RowSignature rowSignature) {
        return new VirtualColumnRegistry(rowSignature, Calcites.findUnusedPrefix("v", new TreeSet<String>(rowSignature.getRowOrder())), new HashMap<String, VirtualColumn>(), new HashMap<String, VirtualColumn>());
    }

    public boolean isVirtualColumnDefined(String virtualColumnName) {
        return this.virtualColumnsByName.containsKey(virtualColumnName);
    }

    public VirtualColumn getOrCreateVirtualColumnForExpression(PlannerContext plannerContext, DruidExpression expression, SqlTypeName typeName) {
        if (!this.virtualColumnsByExpression.containsKey(expression.getExpression())) {
            String virtualColumnName = this.virtualColumnPrefix + this.virtualColumnCounter++;
            ExpressionVirtualColumn virtualColumn = expression.toVirtualColumn(virtualColumnName, Calcites.getValueTypeForSqlTypeName(typeName), plannerContext.getExprMacroTable());
            this.virtualColumnsByExpression.put(expression.getExpression(), (VirtualColumn)virtualColumn);
            this.virtualColumnsByName.put(virtualColumnName, (VirtualColumn)virtualColumn);
        }
        return this.virtualColumnsByExpression.get(expression.getExpression());
    }

    @Nullable
    public VirtualColumn getVirtualColumn(String virtualColumnName) {
        return this.virtualColumnsByName.get(virtualColumnName);
    }

    public RowSignature getFullRowSignature() {
        RowSignature.Builder builder = RowSignature.builder();
        for (String columnName : this.baseRowSignature.getRowOrder()) {
            builder.add(columnName, this.baseRowSignature.getColumnType(columnName));
        }
        for (VirtualColumn virtualColumn : this.virtualColumnsByName.values()) {
            String columnName = virtualColumn.getOutputName();
            builder.add(columnName, virtualColumn.capabilities(columnName).getType());
        }
        return builder.build();
    }
}

