/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.schema;

import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.druid.sql.calcite.table.RowSignature;
import org.apache.druid.timeline.DataSegment;

public class AvailableSegmentMetadata {
    private final DataSegment segment;
    private final long isRealtime;
    private final Set<DruidServerMetadata> segmentServers;
    private final long numRows;
    @Nullable
    private final RowSignature rowSignature;

    public static Builder builder(DataSegment segment, long isRealtime, Set<DruidServerMetadata> segmentServers, RowSignature rowSignature, long numRows) {
        return new Builder(segment, isRealtime, segmentServers, rowSignature, numRows);
    }

    public static Builder from(AvailableSegmentMetadata h) {
        return new Builder(h.getSegment(), h.isRealtime(), h.getReplicas(), h.getRowSignature(), h.getNumRows());
    }

    private AvailableSegmentMetadata(Builder builder) {
        this.rowSignature = builder.rowSignature;
        this.isRealtime = builder.isRealtime;
        this.segmentServers = builder.segmentServers;
        this.numRows = builder.numRows;
        this.segment = builder.segment;
    }

    public long isRealtime() {
        return this.isRealtime;
    }

    public DataSegment getSegment() {
        return this.segment;
    }

    public Set<DruidServerMetadata> getReplicas() {
        return this.segmentServers;
    }

    public long getNumReplicas() {
        return this.segmentServers.size();
    }

    public long getNumRows() {
        return this.numRows;
    }

    @Nullable
    public RowSignature getRowSignature() {
        return this.rowSignature;
    }

    public static class Builder {
        private final DataSegment segment;
        private long isRealtime;
        private Set<DruidServerMetadata> segmentServers;
        @Nullable
        private RowSignature rowSignature;
        private long numRows;

        private Builder(DataSegment segment, long isRealtime, Set<DruidServerMetadata> servers, @Nullable RowSignature rowSignature, long numRows) {
            this.segment = segment;
            this.isRealtime = isRealtime;
            this.segmentServers = servers;
            this.rowSignature = rowSignature;
            this.numRows = numRows;
        }

        public Builder withRowSignature(RowSignature rowSignature) {
            this.rowSignature = rowSignature;
            return this;
        }

        public Builder withNumRows(long numRows) {
            this.numRows = numRows;
            return this;
        }

        public Builder withReplicas(Set<DruidServerMetadata> servers) {
            this.segmentServers = servers;
            return this;
        }

        public Builder withRealtime(long isRealtime) {
            this.isRealtime = isRealtime;
            return this;
        }

        public AvailableSegmentMetadata build() {
            return new AvailableSegmentMetadata(this);
        }
    }
}

