/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.guice;

import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.multibindings.Multibinder;
import java.util.Properties;
import org.apache.druid.guice.Jerseys;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.LifecycleModule;
import org.apache.druid.server.initialization.jetty.JettyBindings;
import org.apache.druid.server.metrics.MetricsModule;
import org.apache.druid.sql.avatica.AvaticaMonitor;
import org.apache.druid.sql.avatica.AvaticaServerConfig;
import org.apache.druid.sql.avatica.DruidAvaticaHandler;
import org.apache.druid.sql.calcite.aggregation.SqlAggregator;
import org.apache.druid.sql.calcite.expression.builtin.QueryLookupOperatorConversion;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerConfig;
import org.apache.druid.sql.calcite.schema.DruidSchema;
import org.apache.druid.sql.calcite.view.NoopViewManager;
import org.apache.druid.sql.calcite.view.ViewManager;
import org.apache.druid.sql.guice.SqlBindings;
import org.apache.druid.sql.http.SqlResource;

public class SqlModule
implements Module {
    private static final String PROPERTY_SQL_ENABLE = "druid.sql.enable";
    private static final String PROPERTY_SQL_ENABLE_JSON_OVER_HTTP = "druid.sql.http.enable";
    private static final String PROPERTY_SQL_ENABLE_AVATICA = "druid.sql.avatica.enable";
    @Inject
    private Properties props;

    public void configure(Binder binder) {
        if (this.isEnabled()) {
            Calcites.setSystemProperties();
            JsonConfigProvider.bind((Binder)binder, (String)"druid.sql.planner", PlannerConfig.class);
            JsonConfigProvider.bind((Binder)binder, (String)"druid.sql.avatica", AvaticaServerConfig.class);
            LifecycleModule.register((Binder)binder, DruidSchema.class);
            binder.bind(ViewManager.class).to(NoopViewManager.class).in(LazySingleton.class);
            Multibinder.newSetBinder((Binder)binder, SqlAggregator.class);
            SqlBindings.addOperatorConversion(binder, QueryLookupOperatorConversion.class);
            if (this.isJsonOverHttpEnabled()) {
                Jerseys.addResource((Binder)binder, SqlResource.class);
            }
            if (this.isAvaticaEnabled()) {
                binder.bind(AvaticaMonitor.class).in(LazySingleton.class);
                JettyBindings.addHandler((Binder)binder, DruidAvaticaHandler.class);
                MetricsModule.register((Binder)binder, AvaticaMonitor.class);
            }
        }
    }

    private boolean isEnabled() {
        Preconditions.checkNotNull((Object)this.props, (Object)"props");
        return Boolean.valueOf(this.props.getProperty(PROPERTY_SQL_ENABLE, "true"));
    }

    private boolean isJsonOverHttpEnabled() {
        Preconditions.checkNotNull((Object)this.props, (Object)"props");
        return Boolean.valueOf(this.props.getProperty(PROPERTY_SQL_ENABLE_JSON_OVER_HTTP, "true"));
    }

    private boolean isAvaticaEnabled() {
        Preconditions.checkNotNull((Object)this.props, (Object)"props");
        return Boolean.valueOf(this.props.getProperty(PROPERTY_SQL_ENABLE_AVATICA, "true"));
    }
}

