/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.com.caucho.hessian.io;

import com.alibaba.com.caucho.hessian.io.AbstractHessianInput;
import com.alibaba.com.caucho.hessian.io.AbstractMapDeserializer;
import com.alibaba.com.caucho.hessian.io.FieldDeserializer2;
import com.alibaba.com.caucho.hessian.io.FieldDeserializer2Factory;
import com.alibaba.com.caucho.hessian.io.HessianFieldException;
import com.alibaba.com.caucho.hessian.io.HessianProtocolException;
import com.alibaba.com.caucho.hessian.io.IOExceptionWrapper;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;

public class JavaDeserializer
extends AbstractMapDeserializer {
    private Class<?> _type;
    private HashMap<?, FieldDeserializer2> _fieldMap;
    private Method _readResolve;
    private Constructor<?> _constructor;
    private Object[] _constructorArgs;

    public JavaDeserializer(Class<?> cl, FieldDeserializer2Factory fieldFactory) {
        this._type = cl;
        this._fieldMap = this.getFieldMap(cl, fieldFactory);
        this._readResolve = this.getReadResolve(cl);
        if (this._readResolve != null) {
            this._readResolve.setAccessible(true);
        }
        this._constructor = this.getConstructor(cl);
        this._constructorArgs = this.getConstructorArgs(this._constructor);
    }

    protected static Object getParamArg(Class<?> cl) {
        if (!cl.isPrimitive()) {
            return null;
        }
        if (Boolean.TYPE.equals(cl)) {
            return Boolean.FALSE;
        }
        if (Byte.TYPE.equals(cl)) {
            return new Byte(0);
        }
        if (Short.TYPE.equals(cl)) {
            return new Short(0);
        }
        if (Character.TYPE.equals(cl)) {
            return new Character('\u0000');
        }
        if (Integer.TYPE.equals(cl)) {
            return 0;
        }
        if (Long.TYPE.equals(cl)) {
            return 0L;
        }
        if (Float.TYPE.equals(cl)) {
            return Float.valueOf(0.0f);
        }
        if (Double.TYPE.equals(cl)) {
            return 0.0;
        }
        throw new UnsupportedOperationException();
    }

    static void logDeserializeError(Field field, Object obj, Object value, Throwable e) throws IOException {
        String fieldName = field.getDeclaringClass().getName() + "." + field.getName();
        if (e instanceof HessianFieldException) {
            throw (HessianFieldException)e;
        }
        if (e instanceof IOException) {
            throw new HessianFieldException(fieldName + ": " + e.getMessage(), e);
        }
        if (value != null) {
            throw new HessianFieldException(fieldName + ": " + value.getClass().getName() + " cannot be assigned to '" + field.getType().getName() + "'", e);
        }
        throw new HessianFieldException(fieldName + ": " + field.getType().getName() + " cannot be assigned from null", e);
    }

    protected Constructor<?> getConstructor(Class<?> cl) {
        Constructor<?>[] constructors = cl.getDeclaredConstructors();
        long bestCost = Long.MAX_VALUE;
        Constructor<?> constructor = null;
        for (int i = 0; i < constructors.length; ++i) {
            Class<?>[] param = constructors[i].getParameterTypes();
            long cost = 0L;
            for (int j = 0; j < param.length; ++j) {
                cost = 4L * cost;
                if (Object.class.equals(param[j])) {
                    ++cost;
                    continue;
                }
                if (String.class.equals(param[j])) {
                    cost += 2L;
                    continue;
                }
                if (Integer.TYPE.equals(param[j])) {
                    cost += 3L;
                    continue;
                }
                if (Long.TYPE.equals(param[j])) {
                    cost += 4L;
                    continue;
                }
                if (param[j].isPrimitive()) {
                    cost += 5L;
                    continue;
                }
                cost += 6L;
            }
            if (cost < 0L || cost > 65536L) {
                cost = 65536L;
            }
            if ((cost += (long)param.length << 48) >= bestCost) continue;
            constructor = constructors[i];
            bestCost = cost;
        }
        if (constructor != null) {
            constructor.setAccessible(true);
        }
        return constructor;
    }

    protected Object[] getConstructorArgs(Constructor<?> constructor) {
        Object[] constructorArgs = null;
        if (constructor != null) {
            Class<?>[] params = constructor.getParameterTypes();
            constructorArgs = new Object[params.length];
            for (int i = 0; i < params.length; ++i) {
                constructorArgs[i] = JavaDeserializer.getParamArg(params[i]);
            }
        }
        return constructorArgs;
    }

    @Override
    public Class<?> getType() {
        return this._type;
    }

    @Override
    public boolean isReadResolve() {
        return this._readResolve != null;
    }

    @Override
    public Object readMap(AbstractHessianInput in) throws IOException {
        try {
            Object obj = this.instantiate();
            return this.readMap(in, obj);
        }
        catch (IOException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOExceptionWrapper(this._type.getName() + ":" + e.getMessage(), e);
        }
    }

    @Override
    public Object[] createFields(int len) {
        return new FieldDeserializer2[len];
    }

    @Override
    public Object createField(String name) {
        FieldDeserializer2 reader = this._fieldMap.get(name);
        if (reader == null) {
            reader = FieldDeserializer2Factory.NullFieldDeserializer.DESER;
        }
        return reader;
    }

    @Override
    public Object readObject(AbstractHessianInput in, Object[] fields) throws IOException {
        try {
            Object obj = this.instantiate();
            return this.readObject(in, obj, (FieldDeserializer2[])fields);
        }
        catch (IOException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOExceptionWrapper(this._type.getName() + ":" + e.getMessage(), e);
        }
    }

    @Override
    public Object readObject(AbstractHessianInput in, String[] fieldNames) throws IOException {
        try {
            Object obj = this.instantiate();
            return this.readObject(in, obj, fieldNames);
        }
        catch (IOException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOExceptionWrapper(this._type.getName() + ":" + e.getMessage(), e);
        }
    }

    protected Method getReadResolve(Class<?> cl) {
        while (cl != null) {
            Method[] methods = cl.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                if (!method.getName().equals("readResolve") || method.getParameterTypes().length != 0) continue;
                return method;
            }
            cl = cl.getSuperclass();
        }
        return null;
    }

    public Object readMap(AbstractHessianInput in, Object obj) throws IOException {
        try {
            int ref = in.addRef(obj);
            while (!in.isEnd()) {
                Object key = in.readObject();
                FieldDeserializer2 deser = this._fieldMap.get(key);
                if (deser != null) {
                    deser.deserialize(in, obj);
                    continue;
                }
                in.readObject();
            }
            in.readMapEnd();
            Object resolve = this.resolve(in, obj);
            if (obj != resolve) {
                in.setRef(ref, resolve);
            }
            return resolve;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOExceptionWrapper(e);
        }
    }

    private Object readObject(AbstractHessianInput in, Object obj, FieldDeserializer2[] fields) throws IOException {
        try {
            int ref = in.addRef(obj);
            for (FieldDeserializer2 reader : fields) {
                reader.deserialize(in, obj);
            }
            Object resolve = this.resolve(in, obj);
            if (obj != resolve) {
                in.setRef(ref, resolve);
            }
            return resolve;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOExceptionWrapper(obj.getClass().getName() + ":" + e, e);
        }
    }

    public Object readObject(AbstractHessianInput in, Object obj, String[] fieldNames) throws IOException {
        try {
            int ref = in.addRef(obj);
            for (String fieldName : fieldNames) {
                FieldDeserializer2 reader = this._fieldMap.get(fieldName);
                if (reader != null) {
                    reader.deserialize(in, obj);
                    continue;
                }
                in.readObject();
            }
            Object resolve = this.resolve(in, obj);
            if (obj != resolve) {
                in.setRef(ref, resolve);
            }
            return resolve;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOExceptionWrapper(obj.getClass().getName() + ":" + e, e);
        }
    }

    protected Object resolve(AbstractHessianInput in, Object obj) throws Exception {
        try {
            if (this._readResolve != null) {
                return this._readResolve.invoke(obj, new Object[0]);
            }
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof Exception) {
                throw (Exception)e.getCause();
            }
            throw e;
        }
        return obj;
    }

    protected Object instantiate() throws Exception {
        try {
            if (this._constructor != null) {
                return this._constructor.newInstance(this._constructorArgs);
            }
            return this._type.newInstance();
        }
        catch (Exception e) {
            throw new HessianProtocolException("'" + this._type.getName() + "' could not be instantiated", e);
        }
    }

    protected HashMap<String, FieldDeserializer2> getFieldMap(Class<?> cl, FieldDeserializer2Factory fieldFactory) {
        HashMap<String, FieldDeserializer2> fieldMap = new HashMap<String, FieldDeserializer2>();
        while (cl != null) {
            Field[] fields = cl.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                if (Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) || fieldMap.get(field.getName()) != null) continue;
                FieldDeserializer2 deser = fieldFactory.create(field);
                fieldMap.put(field.getName(), deser);
            }
            cl = cl.getSuperclass();
        }
        return fieldMap;
    }
}

