/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.commons;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Attributes
extends AbstractSet<Attribute>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final EmptyIterator emptyIterator = new EmptyIterator();
    protected ArrayList<Attribute> attributes = null;

    protected ArrayList<Attribute> list() {
        if (this.attributes == null) {
            this.attributes = new ArrayList(2);
        }
        return this.attributes;
    }

    public Attributes() {
    }

    public Attributes(int size) {
        if (size > 0) {
            this.attributes = new ArrayList(size);
        }
    }

    public Attributes clone() {
        Attributes clone = new Attributes();
        if (this.attributes != null) {
            clone.attributes = new ArrayList<Attribute>(this.attributes);
        }
        return clone;
    }

    @Override
    public Iterator<Attribute> iterator() {
        return this.attributes != null ? this.list().iterator() : emptyIterator;
    }

    @Override
    public int size() {
        return this.attributes != null ? this.attributes.size() : 0;
    }

    @Override
    public void clear() {
        if (this.attributes != null) {
            this.attributes.clear();
        }
    }

    @Override
    public boolean contains(Object item) {
        if (item == null) {
            return false;
        }
        String name = item instanceof Attribute ? ((Attribute)item).getName() : item.toString();
        return this.indexOf(name) >= 0;
    }

    @Override
    public boolean add(Attribute a) {
        this.set(a.getName(), a.getValue());
        return true;
    }

    @Override
    public boolean remove(Object item) {
        if (item == null) {
            return false;
        }
        String name = item instanceof Attribute ? ((Attribute)item).getName() : item.toString();
        int i = this.indexOf(name);
        if (i < 0) {
            return false;
        }
        this.list().remove(i);
        return true;
    }

    public int indexOf(String name) {
        if (this.attributes == null) {
            return -1;
        }
        int size = this.attributes.size();
        for (int i = 0; i < size; ++i) {
            Attribute a = this.attributes.get(i);
            if (!a.getName().equalsIgnoreCase(name)) continue;
            return i;
        }
        return -1;
    }

    public Object get(String name) {
        if (this.attributes == null || name == null || name.length() == 0) {
            return null;
        }
        int i = this.indexOf(name);
        if (i < 0) {
            return null;
        }
        return this.list().get(i).getValue();
    }

    public Attribute set(String name, Object value) {
        if (name == null || name.length() == 0) {
            return null;
        }
        int i = this.indexOf(name);
        if (i < 0) {
            Attribute a = new Attribute(name, value);
            this.list().add(a);
            return a;
        }
        Attribute a = this.list().get(i);
        a.setValue(value);
        return a;
    }

    @Override
    public Object[] toArray() {
        return this.isEmpty() ? new Object[]{} : this.list().toArray();
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{ /*empty*/ }";
        }
        StringBuilder b = new StringBuilder();
        b.append("{");
        boolean first = true;
        for (Attribute a : this.list()) {
            b.append(first ? "\"" : ",\r\n \"");
            String ns = a.getNamespace();
            if (StringUtils.isNotEmpty(ns)) {
                b.append(ns);
                b.append(":");
            }
            b.append(a.getName());
            b.append("\":\"");
            b.append(a.getValue());
            b.append("\"");
            first = false;
        }
        b.append("}");
        return b.toString();
    }

    public void addXml(Element element, long flags) {
        if (this.isEmpty()) {
            return;
        }
        for (Attribute a : this.list()) {
            Object value = a.getValue();
            if (value == null) continue;
            String ns = a.getNamespace();
            if (StringUtils.isNotEmpty(ns)) {
                element.setAttributeNS(ns, a.getName(), String.valueOf(value));
                continue;
            }
            element.setAttribute(a.getName(), String.valueOf(value));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EmptyIterator
    implements Iterator<Attribute> {
        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Attribute next() {
            return null;
        }

        @Override
        public void remove() {
        }
    }

    public static final class Attribute
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String name;
        private String namespace;
        private Object value;

        public Attribute(String name, Object value, String namespace) {
            if (name == null || (this.name = name.trim()).length() == 0) {
                throw new InvalidArgumentException("name", name);
            }
            this.namespace = namespace;
            this.value = value;
        }

        public Attribute(String name, Object value) {
            this(name, value, null);
        }

        public String getName() {
            return this.name;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public boolean equals(Object other) {
            if (this.namespace != null) {
                String otherNs;
                String string = otherNs = other instanceof Attribute ? ((Attribute)other).getNamespace() : null;
                if (!this.namespace.equalsIgnoreCase(otherNs)) {
                    return false;
                }
            }
            String otherName = other instanceof Attribute ? ((Attribute)other).getName() : other.toString();
            return this.name.equalsIgnoreCase(otherName);
        }
    }
}

