/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.data.bean;

import org.apache.empire.commons.Attributes;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.Options;
import org.apache.empire.data.Column;
import org.apache.empire.data.DataMode;
import org.apache.empire.data.DataType;
import org.apache.empire.data.bean.BeanClass;
import org.apache.empire.db.exceptions.FieldNotNullException;

public class BeanProperty
implements Column {
    private final String name;
    private final DataType dataType;
    private final DataMode dataMode;
    private final double size;
    private String controlType;
    private String title;
    private Options options;
    private Attributes attributes;
    protected BeanClass beanClass;

    public BeanProperty(String name, DataType dataType, double size, DataMode dataMode, String controlType) {
        this.name = name;
        this.dataType = dataType;
        this.size = size;
        this.dataMode = dataMode;
        this.controlType = controlType;
    }

    public BeanProperty(String name, DataType dataType, double size, boolean required, String controlType, boolean readOnly) {
        this(name, dataType, size, readOnly ? DataMode.ReadOnly : (required ? DataMode.NotNull : DataMode.Nullable), controlType);
    }

    public BeanProperty(String name, DataType dataType, double size, boolean required) {
        this(name, dataType, size, required ? DataMode.NotNull : DataMode.Nullable, "text");
    }

    public String getName() {
        return this.name;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public Object getAttribute(String name) {
        return this.attributes != null ? this.attributes.get(name) : null;
    }

    public String getTitle() {
        if (this.title == null) {
            return this.name;
        }
        return this.title;
    }

    public Options getOptions() {
        return this.options;
    }

    public String getControlType() {
        return this.controlType;
    }

    public String getBeanPropertyName() {
        return this.name;
    }

    public Column getSourceColumn() {
        return this;
    }

    public double getSize() {
        return this.size;
    }

    public boolean isReadOnly() {
        return this.dataMode == DataMode.ReadOnly || this.dataMode == DataMode.AutoGenerated;
    }

    public boolean isAutoGenerated() {
        return this.dataMode == DataMode.AutoGenerated;
    }

    public boolean isRequired() {
        return this.dataMode == DataMode.NotNull;
    }

    public void validate(Object value) {
        if (ObjectUtils.isEmpty(value) && this.isRequired()) {
            throw new FieldNotNullException(this);
        }
    }

    public BeanClass getBeanClass() {
        return this.beanClass;
    }

    public void setControlType(String controlType) {
        this.controlType = controlType;
    }

    public void setOptions(Options options) {
        this.options = options;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setAttribute(String name, Object value) {
        if (this.attributes == null) {
            this.attributes = new Attributes();
        }
        this.attributes.set(name, value);
    }
}

