/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import java.util.Set;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBBlobData;
import org.apache.empire.db.DBClobData;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBExpr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBCmdParam
extends DBExpr {
    private static final long serialVersionUID = 1L;
    protected DBCommand cmd;
    protected DataType type;
    protected Object value;

    protected DBCmdParam(DBCommand cmd, DataType type, Object value) {
        this.cmd = cmd;
        this.type = type;
        this.value = this.getCmdParamValue(value);
    }

    protected Object getCmdParamValue(Object value) {
        switch (this.type) {
            case BLOB: {
                if (value == null) {
                    return null;
                }
                if (value instanceof DBBlobData) {
                    return value;
                }
                if (value instanceof byte[]) {
                    return new DBBlobData((byte[])value);
                }
                return new DBBlobData(value.toString());
            }
            case CLOB: {
                if (value == null) {
                    return null;
                }
                if (value instanceof DBClobData) {
                    return value;
                }
                return new DBClobData(value.toString());
            }
        }
        return value;
    }

    @Override
    public void addSQL(StringBuilder buf, long context) {
        buf.append("?");
        this.cmd.notifyParamUsage(this);
    }

    @Override
    public void addReferencedColumns(Set<DBColumn> list) {
    }

    @Override
    public DBDatabase getDatabase() {
        return this.cmd.getDatabase();
    }

    public DataType getDataType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = this.getCmdParamValue(value);
    }
}

