/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.Options;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBCmdType;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBDatabaseDriver;
import org.apache.empire.db.DBObject;
import org.apache.empire.db.DBRelation;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.DBSQLScript;
import org.apache.empire.db.DBTable;
import org.apache.empire.db.DBView;
import org.apache.empire.db.exceptions.DatabaseNotOpenException;
import org.apache.empire.db.exceptions.InternalSQLException;
import org.apache.empire.db.exceptions.QueryFailedException;
import org.apache.empire.db.exceptions.QueryNoResultException;
import org.apache.empire.db.exceptions.StatementFailedException;
import org.apache.empire.db.expr.column.DBValueExpr;
import org.apache.empire.exceptions.InternalException;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.ItemExistsException;
import org.apache.empire.exceptions.MiscellaneousErrorException;
import org.apache.empire.exceptions.PropertyReadOnlyException;
import org.apache.empire.exceptions.UnexpectedReturnValueException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DBDatabase
extends DBObject {
    private static final long serialVersionUID = 1L;
    public static final DBSystemDate SYSDATE = new DBSystemDate();
    public static final String EMPTY_STRING = "\u0000";
    private static final Logger log = LoggerFactory.getLogger(DBDatabase.class);
    protected String schema = null;
    protected String linkName = null;
    protected List<DBTable> tables = new ArrayList<DBTable>();
    protected List<DBRelation> relations = new ArrayList<DBRelation>();
    protected List<DBView> views = new ArrayList<DBView>();
    protected DBDatabaseDriver driver = null;
    private boolean preparedStatementsEnabled = false;

    public DBDatabase() {
        this.schema = null;
    }

    public DBDatabase(String schema) {
        this.schema = schema;
    }

    public DBDatabase(String schema, String linkName) {
        this.schema = schema;
        this.linkName = linkName;
    }

    public DBDatabaseDriver getDriver() {
        return this.driver;
    }

    public boolean isPreparedStatementsEnabled() {
        return this.preparedStatementsEnabled;
    }

    public void setPreparedStatementsEnabled(boolean preparedStatementsEnabled) {
        this.preparedStatementsEnabled = preparedStatementsEnabled;
        log.info("PreparedStatementsEnabled is " + preparedStatementsEnabled);
    }

    public void open(DBDatabaseDriver driver, Connection conn) {
        if (this.isOpen()) {
            this.close(conn);
        }
        driver.attachDatabase(this, conn);
        this.driver = driver;
    }

    public void close(Connection conn) {
        if (this.driver != null) {
            this.driver.detachDatabase(this, conn);
        }
        this.driver = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void getCreateDDLScript(DBDatabaseDriver driver, DBSQLScript script) {
        DBDatabaseDriver prevDriver = this.driver;
        try {
            if (this.driver != null && this.driver != driver && driver != null) {
                throw new MiscellaneousErrorException("The database is attached to a different driver.");
            }
            if (this.driver == null) {
                this.driver = driver;
            }
            driver.getDDLScript(DBCmdType.CREATE, this, script);
        }
        finally {
            this.driver = prevDriver;
        }
    }

    @Override
    public DBDatabase getDatabase() {
        return this;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        if (this.driver != null) {
            throw new PropertyReadOnlyException("schema");
        }
        this.schema = schema;
    }

    public String getSchemaPrefix() {
        if (this.schema == null) {
            return "";
        }
        return this.schema + ".";
    }

    public String getLinkName() {
        return this.linkName;
    }

    public void setLinkName(String linkName) {
        if (this.driver != null) {
            throw new PropertyReadOnlyException(linkName);
        }
        this.linkName = linkName;
    }

    @Deprecated
    public String getQualifiedName(String name) {
        StringBuilder buf = new StringBuilder();
        boolean quoteName = this.driver != null ? this.driver.detectQuoteName(name) : false;
        this.appendQualifiedName(buf, name, quoteName);
        return buf.toString();
    }

    public void appendQualifiedName(StringBuilder buf, String name, boolean quoteName) {
        if (this.driver == null) {
            log.warn("No driver attached for appending qualified name {0}.", (Object)name);
            buf.append(name);
            return;
        }
        if (this.schema != null) {
            buf.append(this.schema);
            buf.append(".");
        }
        this.driver.appendElementName(buf, name, quoteName);
        if (this.linkName != null) {
            buf.append(this.driver.getSQLPhrase(5));
            buf.append(this.linkName);
        }
    }

    public DBValueExpr getSystemDateExpr() {
        return new DBValueExpr(this, SYSDATE, DataType.DATETIME);
    }

    public DBValueExpr getValueExpr(String value) {
        return new DBValueExpr(this, value, DataType.TEXT);
    }

    public DBValueExpr getValueExpr(boolean value) {
        return new DBValueExpr(this, value, DataType.BOOL);
    }

    public DBValueExpr getValueExpr(int value) {
        return new DBValueExpr(this, value, DataType.INTEGER);
    }

    public DBValueExpr getValueExpr(long value) {
        return new DBValueExpr(this, value, DataType.INTEGER);
    }

    public DBValueExpr getValueExpr(Object value, DataType dataType) {
        return new DBValueExpr(this, value, dataType);
    }

    protected void addTable(DBTable table) {
        if (table == null || table.getDatabase() != this) {
            throw new InvalidArgumentException("table", table);
        }
        if (this.tables.contains(table)) {
            throw new ItemExistsException((Object)table.getName());
        }
        DBTable existing = this.getTable(table.getName());
        if (existing != null) {
            if (existing.getClass().equals(table.getClass())) {
                return;
            }
            throw new ItemExistsException((Object)table.getName());
        }
        this.tables.add(table);
    }

    public List<DBTable> getTables() {
        return this.tables;
    }

    public DBTable getTable(String name) {
        for (int i = 0; i < this.tables.size(); ++i) {
            DBTable tab = this.tables.get(i);
            if (!tab.getName().equalsIgnoreCase(name)) continue;
            return tab;
        }
        return null;
    }

    public final DBRelation addRelation(DBRelation.DBReference reference) {
        String table = reference.getSourceColumn().getRowSet().getName();
        String col1 = reference.getSourceColumn().getName();
        String name = table.substring(0, Math.min(table.length(), 14)) + "_" + col1.substring(0, Math.min(col1.length(), 12)) + "_FK";
        return this.addRelation(name, new DBRelation.DBReference[]{reference});
    }

    public final DBRelation addRelation(DBRelation.DBReference ref1, DBRelation.DBReference ref2) {
        String table = ref1.getSourceColumn().getRowSet().getName();
        String col1 = ref1.getSourceColumn().getName();
        String col2 = ref2.getSourceColumn().getName();
        String name = table.substring(0, Math.min(table.length(), 9)) + "_" + col1.substring(0, Math.min(col1.length(), 9)) + "_" + col2.substring(0, Math.min(col2.length(), 9)) + "_FK";
        return this.addRelation(name, new DBRelation.DBReference[]{ref1, ref2});
    }

    public DBRelation addRelation(String name, DBRelation.DBReference[] references) {
        if (this.getRelation(name) != null) {
            throw new ItemExistsException((Object)name);
        }
        DBTable targetTable = (DBTable)references[0].getTargetColumn().getRowSet();
        DBRelation.DBCascadeAction deleteAction = targetTable.isCascadeDelete() ? DBRelation.DBCascadeAction.CASCADE_RECORDS : DBRelation.DBCascadeAction.NONE;
        DBRelation relation = new DBRelation(this, name, references, deleteAction);
        if (this.relations.contains(relation)) {
            throw new ItemExistsException((Object)name);
        }
        for (DBRelation.DBReference ref : references) {
            DBRowSet rset = ref.getSourceColumn().getRowSet();
            rset.addColumnReference(ref.getSourceColumn(), ref.getTargetColumn());
        }
        this.relations.add(relation);
        return relation;
    }

    public List<DBRelation> getRelations() {
        return this.relations;
    }

    public DBRelation getRelation(String relationName) {
        for (DBRelation r : this.relations) {
            String name = r.getName();
            if (relationName.compareToIgnoreCase(name) != 0) continue;
            return r;
        }
        return null;
    }

    protected void addView(DBView view) {
        if (view == null || view.getDatabase() != this) {
            throw new InvalidArgumentException("view", view);
        }
        if (this.views.contains(view)) {
            throw new ItemExistsException((Object)view.getName());
        }
        this.views.add(view);
    }

    public List<DBView> getViews() {
        return this.views;
    }

    public DBView getView(String name) {
        for (int i = 0; i < this.views.size(); ++i) {
            DBView view = this.views.get(i);
            if (!view.getName().equalsIgnoreCase(name)) continue;
            return view;
        }
        return null;
    }

    public boolean isOpen() {
        return this.driver != null;
    }

    protected void checkOpen() {
        if (!this.isOpen()) {
            throw new DatabaseNotOpenException(this);
        }
    }

    public DBCommand createCommand() {
        this.checkOpen();
        return this.driver.createCommand(this);
    }

    public Timestamp getUpdateTimestamp(Connection conn) {
        this.checkOpen();
        return this.driver.getUpdateTimestamp(conn);
    }

    public Object getNextSequenceValue(String seqName, Connection conn) {
        this.checkOpen();
        return this.driver.getNextSequenceValue(this, seqName, 1, conn);
    }

    public Object querySingleValue(String sqlCmd, Object[] sqlParams, Connection conn) {
        this.checkOpen();
        ResultSet rs = null;
        try {
            long start = System.currentTimeMillis();
            if (log.isDebugEnabled()) {
                log.debug("executing: " + sqlCmd);
            }
            if ((rs = this.driver.executeQuery(sqlCmd, sqlParams, false, conn)) == null) {
                throw new UnexpectedReturnValueException(rs, "driver.executeQuery()");
            }
            if (!rs.next()) {
                log.debug("querySingleValue returned no result");
                throw new QueryNoResultException(sqlCmd);
            }
            Object result = rs.getObject(1);
            if (log.isDebugEnabled()) {
                log.debug("querySingleValue complete in " + (System.currentTimeMillis() - start) + " ms -> value=" + result);
            }
            Object object = result;
            this.closeResultSet(rs);
            return object;
        }
        catch (SQLException sqle) {
            try {
                throw new QueryFailedException(this, sqlCmd, sqle);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                throw throwable;
            }
        }
    }

    public Object querySingleValue(String sqlCmd, Connection conn) {
        return this.querySingleValue(sqlCmd, null, conn);
    }

    public int querySingleInt(String sqlCmd, Object[] sqlParams, int defVal, Connection conn) {
        Object value = this.querySingleValue(sqlCmd, sqlParams, conn);
        return ObjectUtils.getInteger(value, defVal);
    }

    public int querySingleInt(String sqlCmd, int defVal, Connection conn) {
        Object value = this.querySingleValue(sqlCmd, conn);
        return ObjectUtils.getInteger(value, defVal);
    }

    public final int querySingleInt(String sqlCmd, Connection conn) {
        return this.querySingleInt(sqlCmd, 0, conn);
    }

    public long querySingleLong(String sqlCmd, Object[] sqlParams, long defVal, Connection conn) {
        Object value = this.querySingleValue(sqlCmd, sqlParams, conn);
        return value != null ? Long.parseLong(value.toString()) : defVal;
    }

    public long querySingleLong(String sqlCmd, long defVal, Connection conn) {
        Object value = this.querySingleValue(sqlCmd, conn);
        return value != null ? Long.parseLong(value.toString()) : defVal;
    }

    public final long querySingleLong(String sqlCmd, Connection conn) {
        return this.querySingleLong(sqlCmd, 0L, conn);
    }

    public String querySingleString(String sqlCmd, Object[] sqlParams, String defVal, Connection conn) {
        Object value = this.querySingleValue(sqlCmd, sqlParams, conn);
        return value != null ? value.toString() : defVal;
    }

    public String querySingleString(String sqlCmd, String defVal, Connection conn) {
        Object value = this.querySingleValue(sqlCmd, conn);
        return value != null ? value.toString() : defVal;
    }

    public final String querySingleString(String sqlCmd, Connection conn) {
        return this.querySingleString(sqlCmd, "", conn);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> int querySimpleList(Class<T> c, String sqlCmd, Connection conn, Collection<T> result) {
        int n;
        this.checkOpen();
        ResultSet rs = null;
        try {
            long start = System.currentTimeMillis();
            if (log.isDebugEnabled()) {
                log.debug("executing: " + sqlCmd);
            }
            if ((rs = this.driver.executeQuery(sqlCmd, null, false, conn)) == null) {
                throw new UnexpectedReturnValueException(rs, "driver.executeQuery()");
            }
            int count = 0;
            while (rs.next()) {
                T item = ObjectUtils.convert(c, rs.getObject(1));
                result.add(item);
                ++count;
            }
            if (log.isDebugEnabled()) {
                log.debug("querySimpleList retured " + count + " items. Query completed in " + (System.currentTimeMillis() - start) + " ms");
            }
            n = count;
        }
        catch (ClassCastException e) {
            try {
                log.error("querySingleValue cast exception: ", (Throwable)e);
                throw new InternalException(e);
                catch (SQLException sqle) {
                    throw new QueryFailedException(this, sqlCmd, sqle);
                }
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                throw throwable;
            }
        }
        this.closeResultSet(rs);
        return n;
    }

    public <T> List<T> querySimpleList(Class<T> c, String sqlCmd, Connection conn) {
        ArrayList result = new ArrayList();
        if (this.querySimpleList(c, sqlCmd, conn, result) < 0) {
            return null;
        }
        return result;
    }

    public List<Object> querySimpleList(String sqlCmd, Connection conn) {
        return this.querySimpleList(Object.class, sqlCmd, conn);
    }

    public int queryOptionList(String sqlCmd, Connection conn, Options result) {
        this.checkOpen();
        ResultSet rs = null;
        try {
            long start = System.currentTimeMillis();
            if (log.isDebugEnabled()) {
                log.debug("executing: " + sqlCmd);
            }
            if ((rs = this.driver.executeQuery(sqlCmd, null, false, conn)) == null) {
                throw new UnexpectedReturnValueException(rs, "driver.executeQuery()");
            }
            if (rs.getMetaData().getColumnCount() < 2) {
                throw new InvalidArgumentException("sqlCmd", sqlCmd);
            }
            int count = 0;
            while (rs.next()) {
                Object value = rs.getObject(1);
                String text = rs.getString(2);
                result.add(value, text, true);
                ++count;
            }
            if (log.isDebugEnabled()) {
                log.debug("queryOptionList retured " + count + " items. Query completed in " + (System.currentTimeMillis() - start) + " ms");
            }
            int n = count;
            this.closeResultSet(rs);
            return n;
        }
        catch (SQLException sqle) {
            try {
                throw new QueryFailedException(this, sqlCmd, sqle);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                throw throwable;
            }
        }
    }

    public Options queryOptionList(String sqlCmd, Connection conn) {
        Options options = new Options();
        this.queryOptionList(sqlCmd, conn, options);
        return options;
    }

    public int queryObjectList(String sqlCmd, Connection conn, Collection<Object[]> result) {
        this.checkOpen();
        ResultSet rs = null;
        try {
            long start = System.currentTimeMillis();
            if (log.isDebugEnabled()) {
                log.debug("executing: " + sqlCmd);
            }
            if ((rs = this.driver.executeQuery(sqlCmd, null, false, conn)) == null) {
                throw new UnexpectedReturnValueException(rs, "driver.executeQuery()");
            }
            int colCount = rs.getMetaData().getColumnCount();
            int count = 0;
            while (rs.next()) {
                Object[] item = new Object[colCount];
                for (int i = 0; i < colCount; ++i) {
                    item[i] = rs.getObject(i + 1);
                }
                result.add(item);
                ++count;
            }
            if (log.isDebugEnabled()) {
                log.debug("queryObjectList retured " + count + " items. Query completed in " + (System.currentTimeMillis() - start) + " ms");
            }
            int n = count;
            this.closeResultSet(rs);
            return n;
        }
        catch (SQLException sqle) {
            try {
                throw new QueryFailedException(this, sqlCmd, sqle);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                throw throwable;
            }
        }
    }

    public List<Object[]> queryObjectList(String sqlCmd, Connection conn) {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        if (this.queryObjectList(sqlCmd, conn, result) < 0) {
            return null;
        }
        return result;
    }

    public int executeSQL(String sqlCmd, Object[] sqlParams, Connection conn, DBDatabaseDriver.DBSetGenKeys setGenKeys) {
        this.checkOpen();
        try {
            if (log.isInfoEnabled()) {
                log.info("Executing: " + sqlCmd);
            }
            long start = System.currentTimeMillis();
            int affected = this.driver.executeSQL(sqlCmd, sqlParams, conn, setGenKeys);
            if (affected < 0) {
                throw new UnexpectedReturnValueException(affected, "driver.executeSQL()");
            }
            if (log.isInfoEnabled()) {
                log.info("executeSQL affected " + affected + " Records / " + (System.currentTimeMillis() - start) + "ms");
            }
            return affected;
        }
        catch (SQLException sqle) {
            throw new StatementFailedException(this, sqlCmd, sqle);
        }
    }

    public final int executeSQL(String sqlCmd, Object[] sqlParams, Connection conn) {
        return this.executeSQL(sqlCmd, sqlParams, conn, null);
    }

    public final int executeSQL(String sqlCmd, Connection conn) {
        return this.executeSQL(sqlCmd, null, conn);
    }

    public ResultSet executeQuery(String sqlCmd, Object[] sqlParams, boolean scrollable, Connection conn) {
        this.checkOpen();
        try {
            if (log.isDebugEnabled()) {
                log.debug("Executing: " + sqlCmd);
            }
            long start = System.currentTimeMillis();
            ResultSet rs = this.driver.executeQuery(sqlCmd, sqlParams, scrollable, conn);
            if (rs == null) {
                throw new UnexpectedReturnValueException(rs, "driver.executeQuery()");
            }
            if (log.isDebugEnabled()) {
                log.debug("executeQuery successful in " + (System.currentTimeMillis() - start) + " ms");
            }
            return rs;
        }
        catch (SQLException sqle) {
            throw new QueryFailedException(this, sqlCmd, sqle);
        }
    }

    public void commit(Connection conn) {
        try {
            if (conn == null) {
                throw new InvalidArgumentException("conn", conn);
            }
            if (!conn.getAutoCommit()) {
                conn.commit();
            }
            return;
        }
        catch (SQLException sqle) {
            throw new InternalSQLException(this, sqle);
        }
    }

    public void rollback(Connection conn) {
        try {
            if (conn == null) {
                throw new InvalidArgumentException("conn", conn);
            }
            log.info("Database rollback issued!");
            conn.rollback();
            return;
        }
        catch (SQLException sqle) {
            throw new InternalSQLException(this, sqle);
        }
    }

    public void closeStatement(Statement stmt) {
        try {
            if (stmt != null) {
                stmt.close();
            }
            return;
        }
        catch (SQLException sqle) {
            throw new InternalSQLException(this, sqle);
        }
    }

    public void closeResultSet(ResultSet rset) {
        try {
            if (rset == null) {
                return;
            }
            Statement stmt = rset.getStatement();
            rset.close();
            if (stmt == null) {
                return;
            }
            stmt.close();
            return;
        }
        catch (SQLException sqle) {
            throw new InternalSQLException(this, sqle);
        }
    }

    public static final class DBSystemDate
    implements Serializable {
        private static final long serialVersionUID = 1L;

        private DBSystemDate() {
        }

        public String toString() {
            return "sysdate";
        }
    }
}

