/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBExpr;
import org.apache.empire.db.DBIndex;
import org.apache.empire.exceptions.InvalidArgumentException;

public class DBExpressionIndex
extends DBIndex {
    private static final long serialVersionUID = 1L;
    private DBExpr[] columnExpressions;

    public DBExpressionIndex(String name, boolean unique, DBExpr[] columnExpressions) {
        super(name, unique ? 1 : 0, null);
        if (columnExpressions == null || columnExpressions.length == 0) {
            throw new InvalidArgumentException("columnExpressions", columnExpressions);
        }
        this.columnExpressions = columnExpressions;
    }

    public DBExpressionIndex(String name, boolean unique, DBColumnExpr expr) {
        this(name, unique, new DBColumnExpr[]{expr});
    }

    public DBDatabase getDatabase() {
        return this.columnExpressions[0].getDatabase();
    }

    public DBExpr[] getExpressions() {
        return this.columnExpressions;
    }

    public boolean contains(DBColumn col) {
        for (int i = 0; i < this.columnExpressions.length; ++i) {
            if (!(this.columnExpressions[i] instanceof DBColumnExpr) || !col.equals(((DBColumnExpr)this.columnExpressions[i]).getUpdateColumn())) continue;
            return true;
        }
        return false;
    }

    public int getColumnPos(DBColumn col) {
        return -1;
    }
}

