/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.Options;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBCmdParam;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBRecord;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.exceptions.InvalidKeyException;
import org.apache.empire.db.exceptions.NoPrimaryKeyException;
import org.apache.empire.db.exceptions.QueryNoResultException;
import org.apache.empire.db.exceptions.RecordNotFoundException;
import org.apache.empire.db.exceptions.RecordUpdateFailedException;
import org.apache.empire.db.exceptions.RecordUpdateInvalidException;
import org.apache.empire.db.expr.compare.DBCompareColExpr;
import org.apache.empire.db.expr.compare.DBCompareExpr;
import org.apache.empire.db.expr.join.DBJoinExpr;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.ItemNotFoundException;
import org.apache.empire.exceptions.NotImplementedException;
import org.apache.empire.exceptions.NotSupportedException;
import org.w3c.dom.Element;

public class DBQuery
extends DBRowSet {
    private static final long serialVersionUID = 1L;
    private static AtomicInteger queryCount = new AtomicInteger(0);
    protected DBCommand cmd;
    protected DBColumn[] keyColumns = null;
    protected DBQueryColumn[] queryColumns = null;
    protected String alias;

    public DBQuery(DBCommand cmd, DBColumn[] keyColumns) {
        super(cmd.getDatabase());
        this.cmd = cmd;
        DBColumnExpr[] exprList = cmd.getSelectExprList();
        this.queryColumns = new DBQueryColumn[exprList.length];
        for (int i = 0; i < exprList.length; ++i) {
            this.columns.add(exprList[i].getUpdateColumn());
            this.queryColumns[i] = new DBQueryColumn(this, exprList[i]);
        }
        this.keyColumns = keyColumns;
        this.alias = "q" + String.valueOf(queryCount.incrementAndGet());
    }

    public DBQuery(DBCommand cmd, DBColumn keyColumn) {
        this(cmd, new DBColumn[]{keyColumn});
    }

    public DBQuery(DBCommand cmd) {
        this(cmd, (DBColumn[])null);
    }

    public String getName() {
        return null;
    }

    public String getAlias() {
        return this.alias;
    }

    public boolean isUpdateable() {
        return this.getKeyColumns() != null;
    }

    public DBQueryColumn[] getQueryColumns() {
        return this.queryColumns;
    }

    public DBQueryColumn findQueryColumn(DBColumnExpr expr) {
        for (int i = 0; i < this.queryColumns.length; ++i) {
            if (!this.queryColumns[i].expr.equals(expr)) continue;
            return this.queryColumns[i];
        }
        return null;
    }

    public DBColumn[] getKeyColumns() {
        return this.keyColumns;
    }

    public Object[] getRecordKey(DBRecord record) {
        if (record == null || record.getRowSet() != this) {
            throw new InvalidArgumentException("record", record);
        }
        return (Object[])record.getRowSetData();
    }

    public void addSQL(StringBuilder buf, long context) {
        buf.append("(");
        buf.append(this.cmd.getSelect());
        buf.append(")");
        if ((context & 8L) != 0L && this.alias != null) {
            buf.append(" ");
            buf.append(this.alias);
        }
    }

    public void initRecord(DBRecord rec, Object[] keyValues) {
        this.prepareInitRecord(rec, 0, keyValues);
        Object[] fields = rec.getFields();
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = ObjectUtils.NO_VALUE;
        }
        if (keyValues != null) {
            DBColumn[] keyColumns = this.getKeyColumns();
            for (int i = 0; i < keyColumns.length; ++i) {
                if (!this.columns.contains(keyColumns[i])) continue;
                fields[this.columns.indexOf((Object)keyColumns[i])] = keyValues[i];
            }
        }
        this.completeInitRecord(rec);
    }

    public void createRecord(DBRecord rec, Connection conn) {
        throw new NotImplementedException(this, "createRecord");
    }

    public void readRecord(DBRecord rec, Object[] key, Connection conn) {
        if (conn == null || rec == null) {
            throw new InvalidArgumentException("conn|rec", null);
        }
        DBColumn[] keyColumns = this.getKeyColumns();
        if (key == null || keyColumns.length != key.length) {
            throw new InvalidKeyException(this, key);
        }
        for (int i = 0; i < keyColumns.length; ++i) {
            Object value = key[i];
            if (this.db.isPreparedStatementsEnabled()) {
                value = this.cmd.addParam(keyColumns[i], value);
            }
            this.cmd.where(keyColumns[i].is(value));
        }
        try {
            this.readRecord(rec, this.cmd, conn);
            rec.changeState(1, key.clone());
        }
        catch (QueryNoResultException e) {
            throw new RecordNotFoundException(this, key);
        }
    }

    public void updateRecord(DBRecord rec, Connection conn) {
        if (!this.isUpdateable()) {
            throw new NotSupportedException(this, "updateRecord");
        }
        if (rec == null) {
            throw new InvalidArgumentException("record", null);
        }
        if (conn == null) {
            throw new InvalidArgumentException("conn", null);
        }
        if (!rec.isModified()) {
            return;
        }
        DBColumn[] keyColumns = this.getKeyColumns();
        if (keyColumns == null) {
            throw new NoPrimaryKeyException(this);
        }
        Object[] fields = rec.getFields();
        HashMap<DBRowSet, DBCommand> updCmds = new HashMap<DBRowSet, DBCommand>(3);
        for (int i = 0; i < this.columns.size(); ++i) {
            boolean modified;
            DBColumn col = (DBColumn)this.columns.get(i);
            if (col == null) continue;
            DBRowSet table = col.getRowSet();
            DBCommand updCmd = (DBCommand)updCmds.get(table);
            if (updCmd == null) {
                updCmd = this.db.createCommand();
                updCmds.put(table, updCmd);
            }
            if (!(modified = rec.wasModified(i))) continue;
            if (col.isReadOnly() && log.isDebugEnabled()) {
                log.debug("updateRecord: Read-only column '" + col.getName() + " has been modified!");
            }
            col.checkValue(fields[i]);
            updCmd.set(col.to(fields[i]));
        }
        Object[] keys = (Object[])rec.getRowSetData();
        for (Map.Entry entry : updCmds.entrySet()) {
            int affected;
            int i = 0;
            DBRowSet table = (DBRowSet)entry.getKey();
            DBCommand upd = (DBCommand)entry.getValue();
            if (upd.set == null) continue;
            for (i = 0; this.cmd.joins != null && i < this.cmd.joins.size(); ++i) {
                DBJoinExpr join = this.cmd.joins.get(i);
                DBColumn left = join.getLeft().getUpdateColumn();
                DBColumn right = join.getRight().getUpdateColumn();
                if (left.getRowSet() == table && table.isKeyColumn(left) && !this.addJoinRestriction(upd, left, right, keyColumns, rec)) {
                    throw new ItemNotFoundException((Object)left.getFullName());
                }
                if (right.getRowSet() != table || !table.isKeyColumn(right) || this.addJoinRestriction(upd, right, left, keyColumns, rec)) continue;
                throw new ItemNotFoundException((Object)right.getFullName());
            }
            for (i = 0; this.cmd.where != null && i < this.cmd.where.size(); ++i) {
                DBCompareExpr cmp = this.cmd.where.get(i);
                if (cmp instanceof DBCompareColExpr) {
                    DBCompareColExpr cmpExpr = (DBCompareColExpr)cmp;
                    DBColumn col = cmpExpr.getColumnExpr().getUpdateColumn();
                    if (col == null || col.getRowSet() != table) continue;
                    if (cmpExpr.getValue() instanceof DBCmdParam) {
                        DBColumnExpr colExpr = cmpExpr.getColumnExpr();
                        DBCmdParam param = (DBCmdParam)cmpExpr.getValue();
                        DBCmdParam value = upd.addParam(colExpr, param.getValue());
                        cmp = new DBCompareColExpr(colExpr, cmpExpr.getCmpop(), value);
                    }
                    upd.where(cmp);
                    continue;
                }
                throw new NotSupportedException(this, "updateRecord with " + cmp.getClass().getName());
            }
            for (i = 0; i < keyColumns.length; ++i) {
                if (keyColumns[i].getRowSet() != table) continue;
                Object value = keys[i];
                if (this.db.isPreparedStatementsEnabled()) {
                    value = upd.addParam(keyColumns[i], value);
                }
                upd.where(keyColumns[i].is(value));
            }
            int timestampIndex = -1;
            Timestamp timestampValue = null;
            if (table.getTimestampColumn() != null) {
                DBColumn tsColumn = table.getTimestampColumn();
                timestampIndex = this.getColumnIndex(tsColumn);
                if (timestampIndex >= 0) {
                    timestampValue = this.db.getUpdateTimestamp(conn);
                    Object lastTS = fields[timestampIndex];
                    if (!ObjectUtils.isEmpty(lastTS)) {
                        if (this.db.isPreparedStatementsEnabled()) {
                            lastTS = upd.addParam(tsColumn, lastTS);
                        }
                        upd.where(tsColumn.is(lastTS));
                    }
                    upd.set(tsColumn.to(timestampValue));
                } else {
                    upd.set(tsColumn.to(DBDatabase.SYSDATE));
                }
            }
            if ((affected = this.db.executeSQL(upd.getUpdate(), upd.getParamValues(), conn)) <= 0) {
                if (affected == 0) {
                    throw new RecordUpdateFailedException(this, keys);
                }
                this.db.rollback(conn);
                return;
            }
            if (affected > 1) {
                throw new RecordUpdateInvalidException(this, keys);
            }
            log.info("Record for table '" + table.getName() + " sucessfully updated!");
            if (timestampIndex < 0) continue;
            fields[timestampIndex] = timestampValue;
        }
        rec.changeState(1, keys);
    }

    protected boolean addJoinRestriction(DBCommand upd, DBColumn updCol, DBColumn keyCol, DBColumn[] keyColumns, DBRecord rec) {
        Object rowsetData = rec.getRowSetData();
        for (int i = 0; i < keyColumns.length; ++i) {
            if (keyColumns[i] != keyCol || rowsetData == null) continue;
            upd.where(updCol.is(((Object[])rowsetData)[i]));
            return true;
        }
        int index = this.getColumnIndex(updCol);
        if (index < 0) {
            index = this.getColumnIndex(keyCol);
        }
        if (index >= 0) {
            if (rec.wasModified(index)) {
                return false;
            }
            upd.where(updCol.is(rec.getValue(index)));
            return true;
        }
        return false;
    }

    public void deleteRecord(Object[] keys, Connection conn) {
        throw new NotImplementedException(this, "deleteRecord()");
    }

    public static class DBQueryColumn
    extends DBColumn {
        private static final long serialVersionUID = 1L;
        protected DBColumnExpr expr;

        public DBQueryColumn(DBQuery query, DBColumnExpr expr) {
            super(query, expr.getName());
            this.expr = expr;
        }

        public DataType getDataType() {
            return this.expr.getDataType();
        }

        public double getSize() {
            DBColumn column = this.expr.getUpdateColumn();
            if (column == null) {
                return 0.0;
            }
            return column.getSize();
        }

        public boolean isReadOnly() {
            DBColumn column = this.expr.getUpdateColumn();
            if (column == null) {
                return true;
            }
            return column.isReadOnly();
        }

        public boolean isAutoGenerated() {
            DBColumn column = this.expr.getUpdateColumn();
            if (column == null) {
                return false;
            }
            return column.isAutoGenerated();
        }

        public boolean isRequired() {
            DBColumn column = this.expr.getUpdateColumn();
            if (column == null) {
                return false;
            }
            return column.isRequired();
        }

        public void validate(Object value) {
            DBColumn column = this.expr.getUpdateColumn();
            if (column == null) {
                return;
            }
            column.validate(value);
        }

        public Object getAttribute(String name) {
            if (this.attributes != null && this.attributes.contains(name)) {
                return this.attributes.get(name);
            }
            DBColumn column = this.expr.getUpdateColumn();
            if (column == null) {
                return null;
            }
            return column.getAttribute(name);
        }

        public Options getOptions() {
            if (this.options != null) {
                return this.options;
            }
            DBColumn column = this.expr.getUpdateColumn();
            if (column == null) {
                return null;
            }
            return column.getOptions();
        }

        public Element addXml(Element parent, long flags) {
            return this.expr.addXml(parent, flags);
        }
    }
}

