/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.util.Collection;
import java.util.List;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.Options;
import org.apache.empire.data.Column;
import org.apache.empire.data.ColumnExpr;
import org.apache.empire.data.Record;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBRecordData;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.DBTableColumn;
import org.apache.empire.db.DBXmlDictionary;
import org.apache.empire.db.exceptions.FieldIsReadOnlyException;
import org.apache.empire.exceptions.BeanPropertyGetException;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.ObjectNotValidException;
import org.apache.empire.xml.XMLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBRecord
extends DBRecordData
implements Record,
Cloneable {
    private static final long serialVersionUID = 1L;
    public static final int REC_INVALID = -1;
    public static final int REC_EMTPY = 0;
    public static final int REC_VALID = 1;
    public static final int REC_MODIFIED = 2;
    public static final int REC_NEW = 3;
    protected static final Logger log = LoggerFactory.getLogger(DBRecord.class);
    private int state = -1;
    private DBRowSet rowset = null;
    private Object[] fields = null;
    private boolean[] modified = null;
    private Object rowsetData = null;

    protected void init(DBRowSet rowset, int state, Object rowSetData) {
        if (this.rowset != rowset) {
            this.rowset = rowset;
            this.fields = rowset != null ? new Object[rowset.getColumns().size()] : null;
            this.onRowSetChanged();
        } else if (this.fields != null) {
            for (int i = 0; i < this.fields.length; ++i) {
                this.fields[i] = null;
            }
        }
        this.changeState(state, rowSetData);
    }

    protected Object[] getFields() {
        return this.fields;
    }

    protected void changeState(int state, Object rowSetData) {
        this.state = state;
        this.rowsetData = rowSetData;
        this.modified = null;
    }

    @Override
    public void close() {
        this.init(null, -1, null);
    }

    public DBRecord clone() {
        try {
            DBRecord rec = (DBRecord)super.clone();
            rec.rowset = this.rowset;
            rec.state = this.state;
            if (rec.fields == this.fields && this.fields != null) {
                rec.fields = (Object[])this.fields.clone();
            }
            if (rec.modified == this.modified && this.modified != null) {
                rec.modified = (boolean[])this.modified.clone();
            }
            rec.rowsetData = this.rowsetData;
            return rec;
        }
        catch (CloneNotSupportedException e) {
            log.error("Unable to clone record.", (Throwable)e);
            return null;
        }
    }

    @Override
    public DBDatabase getDatabase() {
        return this.rowset != null ? this.rowset.db : null;
    }

    public DBRowSet getRowSet() {
        return this.rowset;
    }

    public Object getRowSetData() {
        return this.rowsetData;
    }

    public int getState() {
        return this.state;
    }

    @Override
    public boolean isValid() {
        return this.state >= 1;
    }

    @Override
    public boolean isReadOnly() {
        if (!this.isValid()) {
            return true;
        }
        DBRowSet rowset = this.getRowSet();
        return rowset == null || !rowset.isUpdateable();
    }

    @Override
    public boolean isModified() {
        return this.state >= 2;
    }

    @Override
    public boolean isNew() {
        return this.state == 3;
    }

    @Override
    public int getFieldCount() {
        return this.fields != null ? this.fields.length : 0;
    }

    @Override
    public int getFieldIndex(ColumnExpr column) {
        DBColumnExpr expr = (DBColumnExpr)column;
        return this.rowset != null ? this.rowset.getColumnIndex(expr.getUpdateColumn()) : -1;
    }

    @Override
    public int getFieldIndex(String column) {
        if (this.rowset != null) {
            List<DBColumn> columns = this.rowset.getColumns();
            for (int i = 0; i < columns.size(); ++i) {
                DBColumn col = columns.get(i);
                if (!col.getName().equalsIgnoreCase(column)) continue;
                return i;
            }
        }
        return -1;
    }

    public DBColumn getDBColumn(int index) {
        return this.rowset != null ? this.rowset.getColumn(index) : null;
    }

    @Override
    public final Column getColumn(int index) {
        return this.getDBColumn(index);
    }

    @Override
    public final ColumnExpr getColumnExpr(int index) {
        return this.getDBColumn(index);
    }

    public boolean wasModified(int index) {
        if (this.rowset == null) {
            throw new ObjectNotValidException(this);
        }
        if (index < 0 || index >= this.fields.length) {
            throw new InvalidArgumentException("index", index);
        }
        if (this.modified == null) {
            return false;
        }
        return this.modified[index];
    }

    @Override
    public final boolean wasModified(Column column) {
        return this.wasModified(this.getFieldIndex(column));
    }

    public void setModified(DBColumn column, boolean isModified) {
        int index;
        if (this.modified == null) {
            this.modified = new boolean[this.fields.length];
            for (int j = 0; j < this.fields.length; ++j) {
                this.modified[j] = false;
            }
        }
        if ((index = this.getFieldIndex(column)) >= 0) {
            this.modified[index] = isModified;
        }
        if (this.state < 2 && isModified) {
            this.state = 2;
        }
        if (this.state == 2 && !isModified) {
            boolean recordNotModified = true;
            for (int j = 0; j < this.fields.length; ++j) {
                if (!this.modified[j]) continue;
                recordNotModified = false;
            }
            if (recordNotModified) {
                this.state = 1;
            }
        }
    }

    @Override
    public Column[] getKeyColumns() {
        return this.rowset.getKeyColumns();
    }

    public Object[] getKeyValues() {
        return this.rowset != null ? this.rowset.getRecordKey(this) : null;
    }

    @Override
    public Object getValue(int index) {
        if (this.fields == null) {
            throw new ObjectNotValidException(this);
        }
        if (index < 0 || index >= this.fields.length) {
            throw new InvalidArgumentException("index", index);
        }
        if (this.fields[index] == ObjectUtils.NO_VALUE) {
            return null;
        }
        return this.fields[index];
    }

    public boolean isValueValid(int index) {
        if (this.fields == null) {
            throw new ObjectNotValidException(this);
        }
        if (index < 0 || index >= this.fields.length) {
            throw new InvalidArgumentException("index", index);
        }
        return this.fields[index] != ObjectUtils.NO_VALUE;
    }

    public Options getFieldOptions(DBColumn column) {
        return column.getOptions();
    }

    @Override
    public final Options getFieldOptions(Column column) {
        return this.getFieldOptions((DBColumn)column);
    }

    public void modifyValue(int i, Object value) {
        if (this.modified == null) {
            this.modified = new boolean[this.fields.length];
            for (int j = 0; j < this.fields.length; ++j) {
                this.modified[j] = false;
            }
        }
        if (this.fields[i] != ObjectUtils.NO_VALUE || value != null) {
            this.modified[i] = true;
        }
        this.fields[i] = value;
        if (this.state < 2) {
            this.state = 2;
        }
        this.onFieldChanged(i);
    }

    @Override
    public void setValue(int index, Object value) {
        if (this.rowset == null) {
            throw new ObjectNotValidException(this);
        }
        if (index < 0 || index >= this.fields.length) {
            throw new InvalidArgumentException("index", index);
        }
        if (value instanceof String && ((String)value).length() == 0) {
            value = null;
        }
        if (ObjectUtils.compareEqual(this.fields[index], value)) {
            return;
        }
        DBColumn column = this.rowset.getColumn(index);
        if (column.isAutoGenerated()) {
            throw new FieldIsReadOnlyException(column);
        }
        column.validate(value);
        this.modifyValue(index, value);
    }

    @Override
    public final void setValue(Column column, Object value) {
        if (this.rowset == null) {
            throw new ObjectNotValidException(this);
        }
        this.setValue(this.rowset.getColumnIndex(column), value);
    }

    public boolean isFieldReadOnly(DBColumn column) {
        if (this.rowset == null) {
            throw new ObjectNotValidException(this);
        }
        return this.rowset.isColumnReadOnly(column);
    }

    @Override
    public final boolean isFieldReadOnly(Column column) {
        return this.isFieldReadOnly((DBColumn)column);
    }

    public boolean isFieldVisible(DBColumn column) {
        if (this.rowset == null) {
            throw new ObjectNotValidException(this);
        }
        int index = this.rowset.getColumnIndex(column);
        return index >= 0 && this.isValueValid(index);
    }

    @Override
    public final boolean isFieldVisible(Column column) {
        return this.isFieldVisible((DBColumn)column);
    }

    public void init(DBRowSet table, Object[] keyValues, boolean insert) {
        table.initRecord(this, keyValues);
        if (insert) {
            this.state = 3;
        }
    }

    public void create(DBRowSet table, Connection conn) {
        table.createRecord(this, conn);
    }

    public void create(DBRowSet table) {
        this.create(table, null);
    }

    public void read(DBRowSet table, Object[] keys, Connection conn) {
        table.readRecord(this, keys, conn);
    }

    public final void read(DBRowSet table, Object id, Connection conn) {
        if (id instanceof Collection) {
            this.read(table, ((Collection)id).toArray(), conn);
        }
        this.read(table, new Object[]{id}, conn);
    }

    public void update(Connection conn) {
        if (this.rowset == null) {
            throw new ObjectNotValidException(this);
        }
        this.rowset.updateRecord(this, conn);
    }

    public void delete(Connection conn) {
        if (!this.isValid()) {
            throw new ObjectNotValidException(this);
        }
        if (!this.isNew()) {
            Object[] keys = this.rowset.getRecordKey(this);
            this.rowset.deleteRecord(keys, conn);
        }
        this.close();
    }

    @Override
    public int addColumnDesc(Element parent) {
        if (this.rowset == null) {
            throw new ObjectNotValidException(this);
        }
        int count = 0;
        List<DBColumn> columns = this.rowset.getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            DBColumn column = columns.get(i);
            if (!this.isFieldVisible(column)) continue;
            column.addXml(parent, 0L);
            ++count;
        }
        return count;
    }

    @Override
    public int addRowValues(Element parent) {
        if (this.rowset == null) {
            throw new ObjectNotValidException(this);
        }
        DBColumn[] keyColumns = this.rowset.getKeyColumns();
        if (keyColumns != null && keyColumns.length > 0) {
            if (keyColumns.length > 1) {
                StringBuilder buf = new StringBuilder();
                for (int i = 0; i < keyColumns.length; ++i) {
                    if (i > 0) {
                        buf.append("/");
                    }
                    buf.append(this.getString(keyColumns[i]));
                }
                parent.setAttribute("id", buf.toString());
            } else {
                parent.setAttribute("id", this.getString(keyColumns[0]));
            }
        }
        if (this.isNew()) {
            parent.setAttribute("new", "1");
        }
        int count = 0;
        List<DBColumn> columns = this.rowset.getColumns();
        for (int i = 0; i < this.fields.length; ++i) {
            DBColumn column = columns.get(i);
            if (!this.isFieldVisible(column)) continue;
            String name = column.getName();
            if (this.fields[i] != null) {
                XMLUtil.addElement(parent, name, this.getString(i));
            } else {
                XMLUtil.addElement(parent, name).setAttribute("null", "yes");
            }
            ++count;
        }
        return count;
    }

    protected DBXmlDictionary getXmlDictionary() {
        return DBXmlDictionary.getInstance();
    }

    @Override
    public Document getXmlDocument() {
        if (this.rowset == null) {
            throw new ObjectNotValidException(this);
        }
        DBXmlDictionary xmlDic = this.getXmlDictionary();
        Element root = XMLUtil.createDocument(xmlDic.getRowSetElementName());
        if (this.rowset.getName() != null) {
            root.setAttribute("name", this.rowset.getName());
        }
        if (this.addColumnDesc(root) > 0) {
            this.addRowValues(XMLUtil.addElement(root, xmlDic.getRowElementName()));
        }
        return root.getOwnerDocument();
    }

    public int fillMissingDefaults(Connection conn) {
        int count = 0;
        for (int i = 0; i < this.fields.length; ++i) {
            DBTableColumn col;
            Object value;
            if (this.fields[i] != ObjectUtils.NO_VALUE || (value = (col = (DBTableColumn)this.rowset.getColumn(i)).getRecordDefaultValue(conn)) == null) continue;
            this.modifyValue(i, value);
            ++count;
        }
        return count;
    }

    protected void setBeanValue(Object bean, String property, Column column) {
        try {
            PropertyUtilsBean pub = BeanUtilsBean.getInstance().getPropertyUtils();
            Object value = pub.getSimpleProperty(bean, property);
            this.setValue(column, value);
        }
        catch (IllegalAccessException e) {
            log.error(bean.getClass().getName() + ": unable to get property '" + property + "'");
            throw new BeanPropertyGetException(bean, property, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.error(bean.getClass().getName() + ": unable to get property '" + property + "'");
            throw new BeanPropertyGetException(bean, property, (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            log.warn(bean.getClass().getName() + ": no getter available for property '" + property + "'");
            throw new BeanPropertyGetException(bean, property, (Throwable)e);
        }
    }

    @Override
    public int setBeanValues(Object bean, Collection<Column> ignoreList) {
        int count = 0;
        for (int i = 0; i < this.getFieldCount(); ++i) {
            DBColumn column = this.getDBColumn(i);
            if (column.isReadOnly() || ignoreList != null && ignoreList.contains(column)) continue;
            String property = column.getBeanPropertyName();
            this.setBeanValue(bean, property, column);
            ++count;
        }
        return count;
    }

    @Override
    public final int setBeanValues(Object bean) {
        return this.setBeanValues(bean, null);
    }

    protected void onRowSetChanged() {
        if (log.isTraceEnabled() && this.rowset != null) {
            log.trace("Record has been attached to rowset " + this.rowset.getName());
        }
    }

    protected void onRecordChanged() {
        if (log.isTraceEnabled() && this.isValid()) {
            log.trace("Record has been changed");
        }
    }

    protected void onFieldChanged(int i) {
        if (log.isDebugEnabled()) {
            log.debug("Record field " + this.rowset.getColumn(i).getName() + " changed to " + String.valueOf(this.fields[i]));
        }
    }
}

