/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import java.io.Serializable;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBObject;
import org.apache.empire.db.DBTableColumn;

public class DBRelation
extends DBObject {
    private static final long serialVersionUID = 1L;
    private DBDatabase db;
    private String name;
    private DBReference[] references;
    private DBCascadeAction onDeleteAction;

    public DBRelation(DBDatabase db, String name, DBReference[] references, DBCascadeAction onDeleteAction) {
        this.db = db;
        this.name = name;
        this.references = references;
        this.onDeleteAction = onDeleteAction;
    }

    public DBRelation(DBDatabase db, String name, DBReference[] references) {
        this(db, name, references, DBCascadeAction.NONE);
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        String schema = this.db.getSchema();
        return schema != null ? schema + "." + this.name : this.name;
    }

    public DBReference[] getReferences() {
        return this.references;
    }

    public DBDatabase getDatabase() {
        return this.db;
    }

    public DBCascadeAction getOnDeleteAction() {
        return this.onDeleteAction;
    }

    public void setOnDeleteAction(DBCascadeAction onDeleteAction) {
        this.onDeleteAction = onDeleteAction;
    }

    public void onDeleteCascade() {
        this.setOnDeleteAction(DBCascadeAction.CASCADE);
    }

    public void onDeleteCascadeRecords() {
        this.setOnDeleteAction(DBCascadeAction.CASCADE_RECORDS);
    }

    public static class DBReference
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private DBTableColumn sourceColumn;
        private DBTableColumn targetColumn;

        public DBReference(DBTableColumn sourceColumn, DBTableColumn targetColumn) {
            this.sourceColumn = sourceColumn;
            this.targetColumn = targetColumn;
        }

        public DBTableColumn getSourceColumn() {
            return this.sourceColumn;
        }

        public DBTableColumn getTargetColumn() {
            return this.targetColumn;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DBCascadeAction {
        NONE,
        CASCADE,
        CASCADE_RECORDS;

    }
}

